/*
 * Decompiled with CFR 0.152.
 */
package split.com.google.common.collect;

import java.util.NoSuchElementException;
import split.com.google.common.annotations.GwtCompatible;
import split.com.google.common.collect.UnmodifiableIterator;
import split.org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    private @Nullable T nextOrNull;

    protected AbstractSequentialIterator(@Nullable T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract @Nullable T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

