/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.split.client.LocalhostSplit;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitAndKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public abstract class AbstractLocalhostSplitFile
extends Thread {
    private static final Logger _log = LoggerFactory.getLogger(AbstractLocalhostSplitFile.class);
    protected final LocalhostSplitFactory _splitFactory;
    protected final File _file;
    protected final WatchService _watcher;
    protected final AtomicBoolean _stop;

    public AbstractLocalhostSplitFile(LocalhostSplitFactory splitFactory, String directory, String fileName) throws IOException {
        Preconditions.checkNotNull(directory);
        Preconditions.checkNotNull(fileName);
        this._splitFactory = Preconditions.checkNotNull(splitFactory);
        this._file = directory.length() > 0 ? new File(directory, fileName) : new File(fileName);
        this._watcher = FileSystems.getDefault().newWatchService();
        this._stop = new AtomicBoolean(false);
    }

    public boolean isStopped() {
        return this._stop.get();
    }

    public void stopThread() {
        this._stop.set(true);
    }

    public void registerWatcher() throws IOException {
        Path path = this._file.toPath().toAbsolutePath().getParent();
        path.register(this._watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
    }

    @Override
    public void run() {
        try {
            while (!this.isStopped()) {
                WatchKey key;
                try {
                    key = this._watcher.poll(250L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.stopThread();
                    return;
                }
                if (key == null) {
                    Thread.yield();
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    boolean valid;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY && filename.toString().equals(this._file.getName())) {
                        Map<SplitAndKey, LocalhostSplit> featureToSplitMap = this.readOnSplits();
                        this._splitFactory.updateFeatureToTreatmentMap(featureToSplitMap);
                        _log.info("Detected change in Local Splits file - Splits Reloaded! file={}", (Object)this._file.getPath());
                    }
                    if (valid = key.reset()) continue;
                    break;
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            _log.error("Error reading file: path={}", (Object)this._file.getPath(), (Object)e);
            this.stopThread();
        }
    }

    public abstract Map<SplitAndKey, LocalhostSplit> readOnSplits() throws IOException;
}

