/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;

public class SplitKillNotification
extends IncomingNotification {
    private final long changeNumber;
    private final String defaultTreatment;
    private final String splitName;

    public SplitKillNotification(GenericNotificationData genericNotificationData) {
        super(IncomingNotification.Type.SPLIT_KILL, genericNotificationData.getChannel());
        this.changeNumber = genericNotificationData.getChangeNumber();
        this.defaultTreatment = genericNotificationData.getDefaultTreatment();
        this.splitName = genericNotificationData.getSplitName();
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public String getDefaultTreatment() {
        return this.defaultTreatment;
    }

    public String getSplitName() {
        return this.splitName;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processSplitKill(this.getChangeNumber(), this.getSplitName(), this.getDefaultTreatment());
    }

    public String toString() {
        return String.format("Type: %s; Channel: %s; ChangeNumber: %s; DefaultTreatment: %s; SplitName: %s", new Object[]{this.getType(), this.getChannel(), this.getChangeNumber(), this.getDefaultTreatment(), this.getSplitName()});
    }
}

