/*
 * Decompiled with CFR 0.152.
 */
package io.split.integrations;

import io.split.client.impressions.ImpressionListener;
import io.split.integrations.NewRelicListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationsConfig {
    private static final Logger _log = LoggerFactory.getLogger(IntegrationsConfig.class);
    private List<ImpressionListenerWithMeta> _impressionListeners;

    private IntegrationsConfig(List<ImpressionListenerWithMeta> impressionListeners) {
        this._impressionListeners = impressionListeners;
    }

    public List<ImpressionListenerWithMeta> getImpressionsListeners(Execution execution) {
        ArrayList<ImpressionListenerWithMeta> filtered = new ArrayList<ImpressionListenerWithMeta>();
        for (ImpressionListenerWithMeta listener : this._impressionListeners) {
            if (!listener.execution().equals((Object)execution)) continue;
            filtered.add(listener);
        }
        return filtered;
    }

    public void addStandardImpressionListener(ImpressionListener listener, int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("An ImpressionListener was provided, but its capacity was non-positive: " + queueSize);
        }
        this._impressionListeners.add(new ImpressionListenerWithMeta(listener, Execution.ASYNC, queueSize));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ImpressionListenerWithMeta {
        private final ImpressionListener _listener;
        private final Execution _execution;
        private final int _queueSize;

        ImpressionListenerWithMeta(ImpressionListener listener, Execution execution, int queueSize) {
            this._listener = listener;
            this._execution = execution;
            this._queueSize = queueSize;
        }

        public ImpressionListener listener() {
            return this._listener;
        }

        Execution execution() {
            return this._execution;
        }

        public int queueSize() {
            return this._queueSize;
        }
    }

    public static enum Execution {
        SYNC,
        ASYNC;

    }

    public static class Builder {
        private List<ImpressionListenerWithMeta> _listeners = new ArrayList<ImpressionListenerWithMeta>();
        private boolean _newRelicEnabled = false;

        public Builder impressionsListener(ImpressionListener listener, int queueSize) {
            if (queueSize <= 0) {
                throw new IllegalArgumentException("An ImpressionListener was provided, but its capacity was non-positive: " + queueSize);
            }
            this._listeners.add(new ImpressionListenerWithMeta(listener, Execution.ASYNC, queueSize));
            return this;
        }

        public Builder newRelicImpressionListener() {
            if (this._newRelicEnabled) {
                _log.warn("You can only add one new relic integration instance. Ignoring");
                return this;
            }
            try {
                this._listeners.add(new ImpressionListenerWithMeta(new NewRelicListener(), Execution.SYNC, 0));
                _log.info("Added New Relic Impression Listener");
                this._newRelicEnabled = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                _log.warn("New Relic agent not found. Continuing without it", (Throwable)e);
            }
            catch (Exception e) {
                _log.warn("Failed to check if the New Relic Agent is running", (Throwable)e);
            }
            return this;
        }

        public IntegrationsConfig build() {
            return new IntegrationsConfig(this._listeners);
        }
    }
}

