/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.ResolvedMethodParameter;

class ActionSpecification {
    private final Collection<RequestMethod> supportedMethods;
    private final Set<MediaType> produces;
    private final Set<MediaType> consumes;
    private final List<ResolvedMethodParameter> parameters;
    private final ResolvedType returnType;
    private final HandlerMethod handlerMethod;
    private final String name;
    private final String path;

    public ActionSpecification(String name, String path, Collection<RequestMethod> supportedMethods, Set<MediaType> produces, Set<MediaType> consumes, HandlerMethod handlerMethod, List<ResolvedMethodParameter> parameters, ResolvedType returnType) {
        this.name = name;
        this.path = path;
        this.supportedMethods = supportedMethods;
        this.produces = produces;
        this.consumes = consumes;
        this.parameters = parameters;
        this.returnType = returnType;
        this.handlerMethod = handlerMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public Set<MediaType> getProduces() {
        return this.produces;
    }

    public Set<MediaType> getConsumes() {
        return this.consumes;
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.parameters;
    }

    public ResolvedType getReturnType() {
        return this.returnType;
    }

    public Optional<HandlerMethod> getHandlerMethod() {
        return Optional.fromNullable((Object)this.handlerMethod);
    }

    public Optional<Class<?>> getDeclaringClass() {
        return this.getHandlerMethod().transform(new Function<HandlerMethod, Class<?>>(){

            public Class<?> apply(HandlerMethod input) {
                if (AopUtils.isAopProxy((Object)ActionSpecification.this.handlerMethod.getBean())) {
                    return AopUtils.getTargetClass((Object)ActionSpecification.this.handlerMethod.getBean());
                }
                return ActionSpecification.this.handlerMethod.getBeanType();
            }
        });
    }
}

