/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.rest.webmvc.mapping.Associations;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.EntityAssociationContext;
import springfox.documentation.spring.data.rest.EntityAssociationOperationsExtractor;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;

public class EntityAssociationsExtractor
implements EntityOperationsExtractor {
    @Override
    public List<RequestHandler> extract(final EntityContext context) {
        final ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        final Associations associations = context.getAssociations();
        entity.doWithAssociations(new SimpleAssociationHandler(){

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty property = association.getInverse();
                if (!associations.isLinkableAssociation(property)) {
                    return;
                }
                EntityAssociationContext associationContext = new EntityAssociationContext(context, association);
                handlers.addAll(FluentIterable.from(context.getAssociationExtractors()).transformAndConcat(EntityAssociationsExtractor.this.extractHandlers(associationContext)).toList());
            }
        });
        return handlers;
    }

    private Function<EntityAssociationOperationsExtractor, Iterable<RequestHandler>> extractHandlers(final EntityAssociationContext associationContext) {
        return new Function<EntityAssociationOperationsExtractor, Iterable<RequestHandler>>(){

            public Iterable<RequestHandler> apply(EntityAssociationOperationsExtractor input) {
                return input.extract(associationContext);
            }
        };
    }
}

