/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.boot.test.autoconfigure.web.servlet;

import io.springlets.boot.test.autoconfigure.web.servlet.SpringletsWebMvcTest;
import io.springlets.web.mvc.util.MethodLinkFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class SpringletsWebMvcExcludeFilter
extends AnnotationCustomizableTypeExcludeFilter {
    private static final Set<Class<?>> DEFAULT_INCLUDES;
    private static final Set<Class<?>> DEFAULT_INCLUDES_AND_CONTROLLER;
    private final SpringletsWebMvcTest annotation;

    SpringletsWebMvcExcludeFilter(Class<?> testClass) {
        this.annotation = (SpringletsWebMvcTest)AnnotatedElementUtils.getMergedAnnotation(testClass, SpringletsWebMvcTest.class);
    }

    protected boolean hasAnnotation() {
        return this.annotation != null;
    }

    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        switch (type) {
            case INCLUDE: {
                return this.annotation.includeFilters();
            }
            case EXCLUDE: {
                return this.annotation.excludeFilters();
            }
        }
        throw new IllegalStateException("Unsupported type " + type);
    }

    protected boolean isUseDefaultFilters() {
        return this.annotation.useDefaultFilters();
    }

    protected Set<Class<?>> getDefaultIncludes() {
        if (ObjectUtils.isEmpty((Object[])this.annotation.controllers())) {
            return DEFAULT_INCLUDES_AND_CONTROLLER;
        }
        return DEFAULT_INCLUDES;
    }

    protected boolean defaultInclude(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (super.defaultInclude(metadataReader, metadataReaderFactory)) {
            return true;
        }
        for (Class<?> controller : this.annotation.controllers()) {
            if (!this.isTypeOrAnnotated(metadataReader, metadataReaderFactory, controller)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<Object> includes = new LinkedHashSet<Class>();
        includes.add(ControllerAdvice.class);
        includes.add(JsonComponent.class);
        includes.add(WebMvcConfigurer.class);
        includes.add(Filter.class);
        includes.add(FilterRegistrationBean.class);
        includes.add(DelegatingFilterProxyRegistrationBean.class);
        includes.add(HandlerMethodArgumentResolver.class);
        includes.add(MethodLinkFactory.class);
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
        includes = new LinkedHashSet(DEFAULT_INCLUDES);
        includes.add(Controller.class);
        DEFAULT_INCLUDES_AND_CONTROLLER = Collections.unmodifiableSet(includes);
    }
}

