/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries;

import io.sqooba.oss.timeseries.TimeSeries;
import io.sqooba.oss.timeseries.TimeSeriesBuilder;
import io.sqooba.oss.timeseries.TimeSeriesMerger$;
import io.sqooba.oss.timeseries.immutable.EmptyTimeDomain$;
import io.sqooba.oss.timeseries.immutable.EmptyTimeSeries$;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import io.sqooba.oss.timeseries.immutable.TSEntry$;
import io.sqooba.oss.timeseries.immutable.TimeDomain;
import io.sqooba.oss.timeseries.immutable.VectorTimeSeries;
import io.sqooba.oss.timeseries.immutable.VectorTimeSeries$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class TimeSeries$ {
    public static TimeSeries$ MODULE$;

    static {
        new TimeSeries$();
    }

    public <T> Seq<TSEntry<T>> fillGaps(Seq<TSEntry<T>> in, T fillValue) {
        return this.ofOrderedEntriesUnsafe(in, this.ofOrderedEntriesUnsafe$default$2(), this.ofOrderedEntriesUnsafe$default$3()).fill(fillValue).entries();
    }

    public <A, B, C> Seq<TSEntry<C>> mergeEntries(Seq<TSEntry<A>> a, Seq<TSEntry<B>> b, Function2<Option<A>, Option<B>, Option<C>> op) {
        return TimeSeriesMerger$.MODULE$.mergeEntries(a, b, true, op);
    }

    public <T> Stream<Tuple2<Object, Stream<TSEntry<T>>>> groupEntries(Stream<TSEntry<T>> entries, int maxNumberOfEntries) {
        return (Stream)entries.grouped(maxNumberOfEntries).toStream().map((Function1 & Serializable & scala.Serializable)substream -> new Tuple2((Object)BoxesRunTime.boxToLong((long)((TSEntry)substream.head()).timestamp()), substream), Stream$.MODULE$.canBuildFrom());
    }

    public <T> Seq<TSEntry<T>> splitEntriesLongerThan(Seq<TSEntry<T>> entries, long entryMaxLength) {
        return (Seq)entries.flatMap((Function1 & Serializable & scala.Serializable)entry -> entry.splitEntriesLongerThan(entryMaxLength).entries(), Seq$.MODULE$.canBuildFrom());
    }

    public <T> Seq<TSEntry<T>> sample(Seq<TSEntry<T>> entries, long start, long sampleRate, boolean useClosestInWindow) {
        return this.rec$1(start, entries.toStream(), sampleRate, useClosestInWindow);
    }

    public <T> TimeDomain unionLooseDomains(Seq<TimeSeries<T>> tss) {
        return (TimeDomain)((TraversableOnce)tss.map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.looseDomain(), Seq$.MODULE$.canBuildFrom())).fold((Object)EmptyTimeDomain$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$36, x$37) -> x$36.looseUnion((TimeDomain)x$37));
    }

    public <T> TimeDomain intersectLooseDomains(Seq<TimeSeries<T>> tss) {
        return tss.isEmpty() ? EmptyTimeDomain$.MODULE$ : (TimeDomain)((TraversableOnce)tss.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.looseDomain(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$39, x$40) -> x$39.intersect((TimeDomain)x$40));
    }

    public <T> TimeSeries<T> ofOrderedEntriesUnsafe(Seq<TSEntry<T>> xs, boolean isCompressed, boolean isDomainContinous) {
        int size = xs.size();
        return size == 0 ? EmptyTimeSeries$.MODULE$ : (size == 1 ? (TimeSeries)xs.head() : VectorTimeSeries$.MODULE$.ofOrderedEntriesUnsafe(xs, isCompressed, isDomainContinous));
    }

    public <T> boolean ofOrderedEntriesUnsafe$default$2() {
        return false;
    }

    public <T> boolean ofOrderedEntriesUnsafe$default$3() {
        return false;
    }

    public <T> TimeSeries<T> ofOrderedEntriesSafe(Seq<TSEntry<T>> xs, boolean compress) {
        return ((TimeSeriesBuilder)xs.foldLeft(this.newBuilder(compress), (Function2 & Serializable & scala.Serializable)(x$41, x$42) -> x$41.$plus$eq(x$42))).result();
    }

    public <T> boolean ofOrderedEntriesSafe$default$2() {
        return true;
    }

    public <T> TimeSeries<T> apply(Seq<TSEntry<T>> entries) {
        return this.ofOrderedEntriesSafe((Seq)entries.sorted(TSEntry$.MODULE$.orderByTs()), this.ofOrderedEntriesSafe$default$2());
    }

    public <T> TimeSeriesBuilder<T> newBuilder(boolean compress) {
        return new VectorTimeSeries.Builder(compress);
    }

    public <T> boolean newBuilder$default$1() {
        return true;
    }

    private static final boolean tooFarToTake$1(TSEntry next, long samplePoint, boolean useClosestInWindow$1, long sampleRate$1) {
        return useClosestInWindow$1 ? next.timestamp() > samplePoint + sampleRate$1 / 2L : next.timestamp() > samplePoint;
    }

    private final Stream rec$1(long samplePoint, Stream remaining, long sampleRate$1, boolean useClosestInWindow$1) {
        Stream stream;
        while (true) {
            TSEntry last;
            Some some;
            TSEntry next;
            Stream stream2 = remaining;
            Some some2 = package$.MODULE$.Stream().unapplySeq((Seq)stream2);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(0) == 0) {
                stream = package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
                break;
            }
            Option option = package$.MODULE$.$plus$colon().unapply((SeqLike)stream2);
            if (!option.isEmpty() && TimeSeries$.tooFarToTake$1(next = (TSEntry)((Tuple2)option.get())._1(), samplePoint, useClosestInWindow$1, sampleRate$1)) {
                samplePoint += sampleRate$1;
                continue;
            }
            Option option2 = package$.MODULE$.$plus$colon().unapply((SeqLike)stream2);
            if (!option2.isEmpty()) {
                TSEntry current = (TSEntry)((Tuple2)option2.get())._1();
                Stream stream3 = (Stream)((Tuple2)option2.get())._2();
                Option option3 = package$.MODULE$.$plus$colon().unapply((SeqLike)stream3);
                if (!option3.isEmpty()) {
                    TSEntry next2 = (TSEntry)((Tuple2)option3.get())._1();
                    if (!useClosestInWindow$1 && samplePoint < current.definedUntil() || useClosestInWindow$1 && (samplePoint < current.definedUntil() && next2.timestamp() > samplePoint + sampleRate$1 / 2L || Math.abs(current.timestamp() - samplePoint) < Math.abs(next2.timestamp() - samplePoint))) {
                        TSEntry tSEntry = new TSEntry(samplePoint, current.value(), sampleRate$1);
                        stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.rec$1(samplePoint + sampleRate$1, remaining, sampleRate$1, useClosestInWindow$1)).$hash$colon$colon(tSEntry);
                        break;
                    }
                }
            }
            if (!(some = Seq$.MODULE$.unapplySeq((Seq)stream2)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && samplePoint < (last = (TSEntry)((SeqLike)some.get()).apply(0)).definedUntil()) {
                TSEntry tSEntry = new TSEntry(samplePoint, last.value(), sampleRate$1);
                stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.rec$1(samplePoint + sampleRate$1, remaining, sampleRate$1, useClosestInWindow$1)).$hash$colon$colon(tSEntry);
                break;
            }
            remaining = (Stream)remaining.tail();
        }
        return stream;
    }

    private TimeSeries$() {
        MODULE$ = this;
    }
}

