/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.immutable;

import io.sqooba.oss.timeseries.TimeSeries;
import io.sqooba.oss.timeseries.TimeSeriesBuilder;
import io.sqooba.oss.timeseries.immutable.ColumnTimeSeries;
import io.sqooba.oss.timeseries.immutable.EmptyTimeSeries$;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

public final class ColumnTimeSeries$
implements scala.Serializable {
    public static ColumnTimeSeries$ MODULE$;

    static {
        new ColumnTimeSeries$();
    }

    private <T> boolean $lessinit$greater$default$4() {
        return false;
    }

    private <T> boolean $lessinit$greater$default$5() {
        return false;
    }

    public <T> TimeSeries<T> ofOrderedEntriesSafe(Seq<TSEntry<T>> entries, boolean compress) {
        return ((TimeSeriesBuilder)entries.foldLeft(this.newBuilder(compress), (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.addOne(x$13))).result();
    }

    public <T> boolean ofOrderedEntriesSafe$default$2() {
        return true;
    }

    public <T> TimeSeries<T> ofColumnVectorsUnsafe(Tuple3<Vector<Object>, Vector<T>, Vector<Object>> columns, boolean isCompressed, boolean isDomainContinuous) {
        TimeSeries<Nothing$> timeSeries;
        Tuple3<Vector<Object>, Vector<T>, Vector<Object>> tuple3 = columns;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Vector timestamps = (Vector)tuple3._1();
        Vector values = (Vector)tuple3._2();
        Vector validities = (Vector)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)timestamps, (Object)values, (Object)validities);
        Tuple3 tuple33 = tuple32;
        Vector timestamps2 = (Vector)tuple33._1();
        Vector values2 = (Vector)tuple33._2();
        Vector validities2 = (Vector)tuple33._3();
        int n = timestamps2.size();
        switch (n) {
            case 0: {
                timeSeries = EmptyTimeSeries$.MODULE$;
                break;
            }
            case 1: {
                timeSeries = new TSEntry<Object>(BoxesRunTime.unboxToLong((Object)timestamps2.head()), values2.head(), BoxesRunTime.unboxToLong((Object)validities2.head()));
                break;
            }
            default: {
                timeSeries = new ColumnTimeSeries((Vector<Object>)timestamps2, values2, (Vector<Object>)validities2, isCompressed, isDomainContinuous);
                break;
            }
        }
        return timeSeries;
    }

    public <T> boolean ofColumnVectorsUnsafe$default$2() {
        return false;
    }

    public <T> boolean ofColumnVectorsUnsafe$default$3() {
        return false;
    }

    public Option<Object> dichotomicSearch(IndexedSeq<Object> timestamps, long targetTimestamp) {
        Option option;
        int n = this.dichotomic(timestamps, targetTimestamp, 0, timestamps.size() - 1, this.dichotomic$default$5());
        if (0 == n) {
            option = timestamps.headOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$15 -> x$15 <= targetTimestamp).map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$16 -> 0);
        } else {
            int n2 = n;
            long l = BoxesRunTime.unboxToLong((Object)timestamps.apply(n2));
            long l2 = l;
            Some some = l2 <= targetTimestamp ? new Some((Object)BoxesRunTime.boxToInteger((int)n2)) : new Some((Object)BoxesRunTime.boxToInteger((int)(n2 - 1)));
            option = some;
        }
        return option;
    }

    private <T> int dichotomic(IndexedSeq<Object> timestamps, long targetTimestamp, int lowerBound, int upperBound, int previousPivot) {
        while (lowerBound <= upperBound) {
            int newPivot = (lowerBound + upperBound) / 2;
            long l = BoxesRunTime.unboxToLong((Object)timestamps.apply(newPivot));
            long l2 = l;
            if (l2 > targetTimestamp) {
                previousPivot = newPivot;
                upperBound = newPivot - 1;
                continue;
            }
            previousPivot = newPivot;
            lowerBound = newPivot + 1;
        }
        return previousPivot;
    }

    private <T> int dichotomic$default$5() {
        return 0;
    }

    public <T> TimeSeriesBuilder<T> newBuilder(boolean compress) {
        return new ColumnTimeSeries.Builder(compress);
    }

    public <T> boolean newBuilder$default$1() {
        return true;
    }

    public <T> ColumnTimeSeries<T> apply(Vector<Object> timestamps, Vector<T> values, Vector<Object> validities, boolean isCompressed, boolean isDomainContinuous) {
        return new ColumnTimeSeries<T>(timestamps, values, validities, isCompressed, isDomainContinuous);
    }

    public <T> boolean apply$default$4() {
        return false;
    }

    public <T> boolean apply$default$5() {
        return false;
    }

    public <T> Option<Tuple5<Vector<Object>, Vector<T>, Vector<Object>, Object, Object>> unapply(ColumnTimeSeries<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.timestamps(), x$0.values(), x$0.validities(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isCompressed()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isDomainContinuous())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ColumnTimeSeries$() {
        MODULE$ = this;
    }
}

