/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.window;

import io.sqooba.oss.timeseries.immutable.TSEntry;
import io.sqooba.oss.timeseries.window.Aggregator;
import io.sqooba.oss.timeseries.window.ReversibleAggregator;
import io.sqooba.oss.timeseries.window.TimeAwareReversibleAggregator;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Queue;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194A!\u0004\b\u00013!A1\u0007\u0001B\u0001B\u0003-A\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0004F\u0001\u0001\u0007I\u0011\u0002$\t\u000f\u001d\u0003\u0001\u0019!C\u0005\u0011\"1a\n\u0001Q!\nABqa\u0014\u0001A\u0002\u0013%\u0001\u000bC\u0004U\u0001\u0001\u0007I\u0011B+\t\r]\u0003\u0001\u0015)\u0003R\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015Q\u0007\u0001\"\u0003l\u00059iU-\u00198BO\u001e\u0014XmZ1u_JT!a\u0004\t\u0002\r]Lg\u000eZ8x\u0015\t\t\"#\u0001\u0006uS6,7/\u001a:jKNT!a\u0005\u000b\u0002\u0007=\u001c8O\u0003\u0002\u0016-\u000511/]8pE\u0006T\u0011aF\u0001\u0003S>\u001c\u0001!\u0006\u0002\u001bOM\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\u0011\u00113%\n\u0019\u000e\u00039I!\u0001\n\b\u0003;QKW.Z!xCJ,'+\u001a<feNL'\r\\3BO\u001e\u0014XmZ1u_J\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\tA+\u0005\u0002+[A\u0011AdK\u0005\u0003Yu\u0011qAT8uQ&tw\r\u0005\u0002\u001d]%\u0011q&\b\u0002\u0004\u0003:L\bC\u0001\u000f2\u0013\t\u0011TD\u0001\u0004E_V\u0014G.Z\u0001\u0002]B\u0019Q'P\u0013\u000f\u0005YZdBA\u001c;\u001b\u0005A$BA\u001d\u0019\u0003\u0019a$o\\8u}%\ta$\u0003\u0002=;\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\u001dqU/\\3sS\u000eT!\u0001P\u000f\u0002\rqJg.\u001b;?)\u0005\u0011ECA\"E!\r\u0011\u0003!\n\u0005\u0006g\t\u0001\u001d\u0001N\u0001\u0004gVlW#\u0001\u0019\u0002\u000fM,Xn\u0018\u0013fcR\u0011\u0011\n\u0014\t\u00039)K!aS\u000f\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u0012\t\t\u00111\u00011\u0003\rAH%M\u0001\u0005gVl\u0007%A\u0005ekJ\fG/[8ogV\t\u0011\u000b\u0005\u0002\u001d%&\u00111+\b\u0002\u0005\u0019>tw-A\u0007ekJ\fG/[8og~#S-\u001d\u000b\u0003\u0013ZCq!T\u0004\u0002\u0002\u0003\u0007\u0011+\u0001\u0006ekJ\fG/[8og\u0002\nAbY;se\u0016tGOV1mk\u0016,\u0012A\u0017\t\u00049m\u0003\u0014B\u0001/\u001e\u0005\u0019y\u0005\u000f^5p]\u0006A\u0011\r\u001a3F]R\u0014\u0018\u0010\u0006\u0002J?\")\u0001M\u0003a\u0001C\u0006)QM\u001c;ssB\u0019!-Z\u0013\u000e\u0003\rT!\u0001\u001a\t\u0002\u0013%lW.\u001e;bE2,\u0017B\u00014d\u0005\u001d!6+\u00128uef\f\u0011\u0002\u001a:pa\u0016sGO]=\u0015\u0005%K\u0007\"\u00021\f\u0001\u0004\t\u0017\u0001C<fS\u001eDG/\u001a3\u0015\u0005Ab\u0007\"B7\r\u0001\u0004\t\u0017!A3")
public class MeanAggregator<T>
implements TimeAwareReversibleAggregator<T, Object> {
    private final Numeric<T> n;
    private double sum;
    private long durations;

    @Override
    public void dropHead(Queue<TSEntry<T>> currentWindow) {
        ReversibleAggregator.dropHead$(this, currentWindow);
    }

    @Override
    public void addAndDrop(TSEntry<T> add, Queue<TSEntry<T>> currentWindow) {
        ReversibleAggregator.addAndDrop$((ReversibleAggregator)this, add, currentWindow);
    }

    @Override
    public void addAndDrop(TSEntry<T> add, TSEntry<T> remove) {
        ReversibleAggregator.addAndDrop$((ReversibleAggregator)this, add, remove);
    }

    @Override
    public void addEntry(TSEntry<T> e, Queue<TSEntry<T>> currentWindow) {
        Aggregator.addEntry$(this, e, currentWindow);
    }

    private double sum() {
        return this.sum;
    }

    private void sum_$eq(double x$1) {
        this.sum = x$1;
    }

    private long durations() {
        return this.durations;
    }

    private void durations_$eq(long x$1) {
        this.durations = x$1;
    }

    @Override
    public Option<Object> currentValue() {
        return this.durations() > 0L ? new Some((Object)BoxesRunTime.boxToDouble((double)(this.sum() / (double)this.durations()))) : None$.MODULE$;
    }

    @Override
    public void addEntry(TSEntry<T> entry) {
        this.sum_$eq(this.sum() + this.weighted(entry));
        this.durations_$eq(this.durations() + entry.validity());
    }

    @Override
    public void dropEntry(TSEntry<T> entry) {
        this.sum_$eq(this.sum() - this.weighted(entry));
        this.durations_$eq(this.durations() - entry.validity());
    }

    private double weighted(TSEntry<T> e) {
        return this.n.mkNumericOps(e.value()).toDouble() * (double)e.validity();
    }

    public MeanAggregator(Numeric<T> n) {
        this.n = n;
        Aggregator.$init$(this);
        ReversibleAggregator.$init$(this);
        this.sum = 0.0;
        this.durations = 0L;
    }
}

