/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.window;

import io.sqooba.oss.timeseries.TimeSeries$;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import io.sqooba.oss.timeseries.window.Aggregator;
import io.sqooba.oss.timeseries.window.DoNothingAggregator$;
import io.sqooba.oss.timeseries.window.ReversibleAggregator;
import io.sqooba.oss.timeseries.window.TimeAwareReversibleAggregator;
import io.sqooba.oss.timeseries.window.TimeUnawareReversibleAggregator;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class WindowSlider$ {
    public static WindowSlider$ MODULE$;

    static {
        new WindowSlider$();
    }

    public <T> Stream<TSEntry<Queue<TSEntry<T>>>> window(Stream<TSEntry<T>> in, long windowWidth) {
        return (Stream)this.window(in, windowWidth, DoNothingAggregator$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$1 -> (TSEntry)x$1._1(), Stream$.MODULE$.canBuildFrom());
    }

    public <T, A> Stream<Tuple2<TSEntry<Queue<TSEntry<T>>>, Option<A>>> window(Stream<TSEntry<T>> in, long windowWidth, TimeUnawareReversibleAggregator<T, A> aggregator) {
        Predef$.MODULE$.require(windowWidth > 0L, (Function0 & Serializable & scala.Serializable)() -> "Needs a strictly positive window size");
        return in.isEmpty() ? package$.MODULE$.Stream().empty() : this.windowRec(in, Queue$.MODULE$.empty(), ((TSEntry)in.head()).timestamp(), windowWidth, aggregator);
    }

    public <T, A> Stream<Tuple2<TSEntry<Queue<TSEntry<T>>>, Option<A>>> window(Stream<TSEntry<T>> in, long windowWidth, TimeAwareReversibleAggregator<T, A> aggregator, long sampleRate, boolean useClosestInWindow) {
        Predef$.MODULE$.require(windowWidth > 0L, (Function0 & Serializable & scala.Serializable)() -> "Needs a strictly positive window size");
        return in.isEmpty() ? package$.MODULE$.Stream().empty() : this.windowRec(TimeSeries$.MODULE$.sample(in, ((TSEntry)in.head()).timestamp(), sampleRate, useClosestInWindow).toStream(), Queue$.MODULE$.empty(), ((TSEntry)in.head()).timestamp(), windowWidth, aggregator);
    }

    public <T, A> boolean window$default$5() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, A> Stream<Tuple2<TSEntry<Queue<TSEntry<T>>>, Option<A>>> windowRec(Stream<TSEntry<T>> remaining, Queue<TSEntry<T>> previousEntryContent, long timeCursor, long windowWidth, ReversibleAggregator<T, A> aggregator) {
        Tuple3<Object, Object, Object> tuple3 = this.whatToUpdate(remaining, previousEntryContent, timeCursor, windowWidth);
        if (tuple3 == null) throw new MatchError(tuple3);
        boolean fromRemaining = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        boolean dropFromWindow = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        long advance = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)fromRemaining), (Object)BoxesRunTime.boxToBoolean((boolean)dropFromWindow), (Object)BoxesRunTime.boxToLong((long)advance));
        Tuple3 tuple33 = tuple32;
        boolean fromRemaining2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
        boolean dropFromWindow2 = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
        long advance2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        if (advance2 == 0L) {
            return package$.MODULE$.Stream().empty();
        }
        long nextCursor = timeCursor + advance2;
        long newValidity = nextCursor - timeCursor;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(fromRemaining2, dropFromWindow2);
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                aggregator.addAndDrop((TSEntry)remaining.head(), previousEntryContent);
                TSEntry<Object> newWindow = new TSEntry<Object>(timeCursor, previousEntryContent.tail().$colon$plus(remaining.head(), Queue$.MODULE$.canBuildFrom()), newValidity);
                Tuple2 tuple2 = new Tuple2(newWindow, aggregator.currentValue());
                return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> MODULE$.windowRec((Stream)remaining.tail(), (Queue)newWindow.value(), nextCursor, windowWidth, aggregator)).$hash$colon$colon((Object)tuple2);
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                aggregator.addEntry((TSEntry)remaining.head(), previousEntryContent);
                TSEntry<Object> newWindow = new TSEntry<Object>(timeCursor, previousEntryContent.$colon$plus(remaining.head(), Queue$.MODULE$.canBuildFrom()), newValidity);
                Tuple2 tuple2 = new Tuple2(newWindow, aggregator.currentValue());
                return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> MODULE$.windowRec((Stream)remaining.tail(), (Queue)newWindow.value(), nextCursor, windowWidth, aggregator)).$hash$colon$colon((Object)tuple2);
            }
        }
        if (sp2 == null) throw new IllegalStateException("Something went very wrong. Please file a bug report. Would you fancy a cup of tea while we fix this?");
        boolean bl = sp2._1$mcZ$sp();
        boolean bl4 = sp2._2$mcZ$sp();
        if (false != bl) throw new IllegalStateException("Something went very wrong. Please file a bug report. Would you fancy a cup of tea while we fix this?");
        if (true != bl4) throw new IllegalStateException("Something went very wrong. Please file a bug report. Would you fancy a cup of tea while we fix this?");
        aggregator.dropHead(previousEntryContent);
        TSEntry<Queue> newWindow = new TSEntry<Queue>(timeCursor, previousEntryContent.tail(), newValidity);
        Tuple2 tuple2 = new Tuple2(newWindow, aggregator.currentValue());
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> MODULE$.windowRec(remaining, (Queue)newWindow.value(), nextCursor, windowWidth, aggregator)).$hash$colon$colon((Object)tuple2);
    }

    public Tuple3<Object, Object, Object> whatToUpdate(Stream<TSEntry<?>> remaining, Queue<TSEntry<?>> previousBucket, long timeCursor, long windowWidth) {
        long l;
        Predef$.MODULE$.assert(remaining.nonEmpty() || previousBucket.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can't accept empty remaining and empty previous window.");
        Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)remaining.headOption().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$whatToUpdate$3(timeCursor, e)))) || BoxesRunTime.unboxToBoolean((Object)previousBucket.headOption().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$whatToUpdate$5(timeCursor, windowWidth, x$6)))) || BoxesRunTime.unboxToBoolean((Object)previousBucket.lastOption().fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$whatToUpdate$7(timeCursor, x$7)))), (Function0 & Serializable & scala.Serializable)() -> "cursor MUST be sitting on the timestamp of the first remaining,the end of validity of the first element in the queue, or the end of validity of the last entry in the queue");
        if (remaining.isEmpty() && ((TSEntry)previousBucket.last()).definedUntil() == timeCursor) {
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToLong((long)0L));
        }
        boolean takeFromRemaining = remaining.headOption().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$whatToUpdate$9(timeCursor, x$8)));
        boolean removeFromWindow = previousBucket.headOption().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$whatToUpdate$10(timeCursor, windowWidth, x$9)));
        Stream<TSEntry<?>> stream = remaining;
        Option option = package$.MODULE$.$plus$colon().unapply(stream);
        if (!option.isEmpty()) {
            TSEntry head = (TSEntry)((Tuple2)option.get())._1();
            Stream tail = (Stream)((Tuple2)option.get())._2();
            l = takeFromRemaining ? BoxesRunTime.unboxToLong((Object)tail.headOption().fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> head.validity(), (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)WindowSlider$.$anonfun$whatToUpdate$12(timeCursor, x$10)))) : head.timestamp() - timeCursor;
        } else {
            l = Long.MAX_VALUE;
        }
        long spaceUntilNextAddition = l;
        long spaceUntilNextRemoval = removeFromWindow ? BoxesRunTime.unboxToLong((Object)previousBucket.tail().headOption().orElse((Function0 & Serializable & scala.Serializable)() -> remaining.headOption()).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE, (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.definedUntil()))) - (timeCursor - windowWidth) : BoxesRunTime.unboxToLong((Object)previousBucket.headOption().fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((TSEntry)remaining.head()).definedUntil(), (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.definedUntil()))) - (timeCursor - windowWidth);
        long advance = Math.min(spaceUntilNextAddition, spaceUntilNextRemoval);
        long nextAdvance = remaining.nonEmpty() ? advance : Math.min(advance, ((TSEntry)previousBucket.last()).definedUntil() - timeCursor);
        Predef$.MODULE$.assert(takeFromRemaining || removeFromWindow, (Function0 & Serializable & scala.Serializable)() -> "Looks like a bug, mate...");
        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)takeFromRemaining), (Object)BoxesRunTime.boxToBoolean((boolean)removeFromWindow), (Object)BoxesRunTime.boxToLong((long)nextAdvance));
    }

    public <T, A> Stream<TSEntry<A>> dynamicWindow(Stream<TSEntry<T>> entries, Function1<TSEntry<T>, Object> start, Function1<TSEntry<T>, Object> stop, Function0<Aggregator<T, A>> aggregator) {
        Stream stream;
        Stream stream2 = entries.dropWhile((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$dynamicWindow$1(start, stop, e)));
        Some some = package$.MODULE$.Stream().unapplySeq((Seq)stream2);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0) {
            stream = package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
        } else {
            Aggregator finalAgg;
            Tuple2 tuple2 = stream2.span((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)WindowSlider$.$anonfun$dynamicWindow$2(stop, x$13)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Stream window = (Stream)tuple2._1();
            Stream remaining = (Stream)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)window, (Object)remaining);
            Tuple2 tuple23 = tuple22;
            Stream window2 = (Stream)tuple23._1();
            Stream remaining2 = (Stream)tuple23._2();
            Tuple2 tuple24 = (Tuple2)window2.foldLeft((Object)new Tuple2(aggregator.apply(), (Object)Queue$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                TSEntry entry;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        entry = (TSEntry)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Aggregator agg = (Aggregator)tuple2._1();
                Queue prevWindow = (Queue)tuple2._2();
                agg.addEntry(entry, prevWindow);
                Tuple2 tuple23 = new Tuple2((Object)agg, prevWindow.$colon$plus((Object)entry, Queue$.MODULE$.canBuildFrom()));
                return tuple23;
            });
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Aggregator aggregator2 = finalAgg = (Aggregator)tuple24._1();
            Aggregator finalAgg2 = aggregator2;
            Option aggregatedEntry = finalAgg2.currentValue().map((Function1 & Serializable & scala.Serializable)x$15 -> new TSEntry<Object>(((TSEntry)window2.head()).timestamp(), x$15, ((TSEntry)window2.last()).definedUntil() - ((TSEntry)window2.head()).timestamp()));
            Stream stream3 = Option$.MODULE$.option2Iterable(aggregatedEntry).toStream();
            stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> MODULE$.dynamicWindow(remaining2, start, stop, aggregator)).$hash$colon$colon$colon(stream3);
        }
        return stream;
    }

    public static final /* synthetic */ boolean $anonfun$whatToUpdate$3(long timeCursor$1, TSEntry e) {
        return e.timestamp() == timeCursor$1;
    }

    public static final /* synthetic */ boolean $anonfun$whatToUpdate$5(long timeCursor$1, long windowWidth$2, TSEntry x$6) {
        return x$6.definedUntil() == timeCursor$1 - windowWidth$2;
    }

    public static final /* synthetic */ boolean $anonfun$whatToUpdate$7(long timeCursor$1, TSEntry x$7) {
        return x$7.definedUntil() == timeCursor$1;
    }

    public static final /* synthetic */ boolean $anonfun$whatToUpdate$9(long timeCursor$1, TSEntry x$8) {
        return x$8.timestamp() - timeCursor$1 == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$whatToUpdate$10(long timeCursor$1, long windowWidth$2, TSEntry x$9) {
        return x$9.definedUntil() - (timeCursor$1 - windowWidth$2) == 0L;
    }

    public static final /* synthetic */ long $anonfun$whatToUpdate$12(long timeCursor$1, TSEntry x$10) {
        return x$10.timestamp() - timeCursor$1;
    }

    public static final /* synthetic */ boolean $anonfun$dynamicWindow$1(Function1 start$1, Function1 stop$1, TSEntry e) {
        return !BoxesRunTime.unboxToBoolean((Object)start$1.apply((Object)e)) || BoxesRunTime.unboxToBoolean((Object)stop$1.apply((Object)e));
    }

    public static final /* synthetic */ boolean $anonfun$dynamicWindow$2(Function1 stop$1, TSEntry x$13) {
        return !BoxesRunTime.unboxToBoolean((Object)stop$1.apply((Object)x$13));
    }

    private WindowSlider$() {
        MODULE$ = this;
    }
}

