/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries;

import io.sqooba.oss.timeseries.NumericTimeSeries$;
import io.sqooba.oss.timeseries.TimeSeries;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import io.sqooba.oss.timeseries.window.Aggregator$;
import io.sqooba.oss.timeseries.window.WindowSlider$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.reflect.api.Internals;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class NumericTimeSeries$ {
    public static final NumericTimeSeries$ MODULE$ = new NumericTimeSeries$();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, U> Option<U> nonStrictPlus(Option<T> lhO, Option<T> rhO, Numeric<U> n) {
        Option option;
        Tuple2 tuple2 = new Tuple2(lhO, rhO);
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object l = some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Object r = some2.value();
                    return new Some(n.mkNumericOps(l).$plus(r));
                }
            }
        }
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option;
            Object l = some.value();
            return new Some(l);
        }
        if (tuple2 == null) return None$.MODULE$;
        Option option4 = (Option)tuple2._2();
        if (!(option4 instanceof Some)) return None$.MODULE$;
        Some some = (Some)option4;
        Object r = some.value();
        return new Some(r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Option<T> nonStrictMinus(Option<T> lhDefault, Option<T> rhDefault, Option<T> lhO, Option<T> rhO, Numeric<T> n) {
        Option option;
        Tuple2 tuple2 = new Tuple2(lhO, rhO);
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object l = some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Object r = some2.value();
                    return new Some(n.mkNumericOps(l).$minus(r));
                }
            }
        }
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option;
            Object l = some.value();
            return rhDefault.map((Function1 & Serializable)x$1 -> n.mkNumericOps(l).$minus(x$1));
        }
        if (tuple2 == null) return rhDefault.flatMap((Function1 & Serializable)rDefault -> lhDefault.map((Function1 & Serializable)x$3 -> n.mkNumericOps(x$3).$minus(rDefault)));
        Option option4 = (Option)tuple2._2();
        if (!(option4 instanceof Some)) return rhDefault.flatMap((Function1 & Serializable)rDefault -> lhDefault.map((Function1 & Serializable)x$3 -> n.mkNumericOps(x$3).$minus(rDefault)));
        Some some = (Some)option4;
        Object r = some.value();
        return lhDefault.map((Function1 & Serializable)x$2 -> n.mkNumericOps(x$2).$minus(r));
    }

    public <T> TimeSeries<T> rolling(TimeSeries<T> ts, Function1<Seq<T>, T> aggregator, long windowMs, boolean compress, Numeric<T> n) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_sqooba_oss_timeseries_NumericTimeSeries$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                Internals.FreeTypeSymbolApi free$T1 = $u.internal().reificationSupport().newFreeType("T", $u.internal().reificationSupport().FlagsRepr().apply(8208L), "defined by rolling in NumericTimeSeries.scala:49:15");
                $u.internal().reificationSupport().setInfo((Symbols.SymbolApi)free$T1, (Types.TypeApi)$u.internal().reificationSupport().TypeBounds($m.staticClass("scala.Nothing").asType().toTypeConstructor(), $m.staticClass("scala.Any").asType().toTypeConstructor()));
                return $u.internal().reificationSupport().TypeRef($u.NoPrefix(), (Symbols.SymbolApi)free$T1, (List)Nil$.MODULE$);
            }

            public Io_sqooba_oss_timeseries_NumericTimeSeries$$typecreator1$1() {
            }
        }
        return ts.mapWithTime((Function2 & Serializable)(time, currentVal) -> aggregator.apply(((SeqOps)ts.slice(BoxesRunTime.unboxToLong((Object)time) - windowMs, BoxesRunTime.unboxToLong((Object)time)).entries().map((Function1 & Serializable)x$4 -> x$4.value())).$colon$plus(currentVal)), compress, ((TypeTags)$u).WeakTypeTag().apply((Mirror)$m, (TypeCreator)new Io_sqooba_oss_timeseries_NumericTimeSeries$$typecreator1$1()));
    }

    public <T> boolean rolling$default$4() {
        return true;
    }

    public <T> Seq<TSEntry<Object>> stepIntegral(Seq<TSEntry<T>> entries, TimeUnit timeUnit, Numeric<T> n) {
        return this.integrateMe(0.0, entries, (Builder<TSEntry<Object>, Seq<TSEntry<Object>>>)Seq$.MODULE$.newBuilder(), timeUnit, n);
    }

    public <T> TimeUnit stepIntegral$default$2() {
        return TimeUnit.MILLISECONDS;
    }

    private <T> Seq<TSEntry<Object>> integrateMe(double sumUntilNow, Seq<TSEntry<T>> seq, Builder<TSEntry<Object>, Seq<TSEntry<Object>>> acc, TimeUnit timeUnit, Numeric<T> n) {
        while (!seq.isEmpty()) {
            double newSum = sumUntilNow + ((TSEntry)seq.head()).integral(timeUnit, n);
            TSEntry qual$1 = (TSEntry)seq.head();
            Function1 & Serializable x$1 = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)newSum);
            boolean x$2 = qual$1.map$default$2();
            acc = (Builder)acc.$plus$eq((Object)qual$1.map(x$1, x$2, ((TypeTags)package$.MODULE$.universe()).WeakTypeTag().Double()));
            seq = (Seq)seq.tail();
            sumUntilNow = newSum;
        }
        return (Seq)acc.result();
    }

    public <T> Seq<TSEntry<Object>> slidingIntegral(Seq<TSEntry<T>> entries, long window, long sampleRate, TimeUnit timeUnit, Numeric<T> n) {
        Predef$.MODULE$.require(window >= sampleRate, (Function0 & Serializable)() -> "The window must be as least as large as the sample rate.");
        return WindowSlider$.MODULE$.window(entries.toStream(), window, Aggregator$.MODULE$.integral(timeUnit, Aggregator$.MODULE$.integral$default$2(), n), sampleRate, WindowSlider$.MODULE$.window$default$5()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TSEntry entry = (TSEntry)tuple2._1();
            Option integral = (Option)tuple2._2();
            TimeSeries timeSeries = entry.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)NumericTimeSeries$.$anonfun$slidingIntegral$3(integral, x$6)), entry.map$default$2(), ((TypeTags)package$.MODULE$.universe()).WeakTypeTag().Double());
            return timeSeries;
        });
    }

    public <T> TimeUnit slidingIntegral$default$4() {
        return TimeUnit.MILLISECONDS;
    }

    public static final /* synthetic */ double $anonfun$slidingIntegral$3(Option integral$1, Queue x$6) {
        return BoxesRunTime.unboxToDouble((Object)integral$1.get());
    }

    private NumericTimeSeries$() {
    }
}

