/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries;

import io.sqooba.oss.timeseries.TimeSeries;
import io.sqooba.oss.timeseries.TimeSeriesBuilder;
import io.sqooba.oss.timeseries.TimeSeriesMerger$;
import io.sqooba.oss.timeseries.immutable.EmptyTimeDomain$;
import io.sqooba.oss.timeseries.immutable.EmptyTimeSeries$;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import io.sqooba.oss.timeseries.immutable.TSEntry$;
import io.sqooba.oss.timeseries.immutable.TimeDomain;
import io.sqooba.oss.timeseries.immutable.VectorTimeSeries;
import io.sqooba.oss.timeseries.immutable.VectorTimeSeries$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class TimeSeries$ {
    public static final TimeSeries$ MODULE$ = new TimeSeries$();

    public <T> Seq<TSEntry<T>> fillGaps(Seq<TSEntry<T>> in, T fillValue) {
        return this.ofOrderedEntriesUnsafe(in, this.ofOrderedEntriesUnsafe$default$2(), this.ofOrderedEntriesUnsafe$default$3()).fill(fillValue).entries();
    }

    public <A, B, C> Seq<TSEntry<C>> mergeEntries(Seq<TSEntry<A>> a, Seq<TSEntry<B>> b, Function2<Option<A>, Option<B>, Option<C>> op) {
        return TimeSeriesMerger$.MODULE$.mergeEntries(a, b, true, op);
    }

    public <T> Stream<Tuple2<Object, Stream<TSEntry<T>>>> groupEntries(Stream<TSEntry<T>> entries, int maxNumberOfEntries) {
        return entries.grouped(maxNumberOfEntries).toStream().map((Function1 & Serializable)substream -> new Tuple2((Object)BoxesRunTime.boxToLong((long)((TSEntry)substream.head()).timestamp()), substream));
    }

    public <T> Seq<TSEntry<T>> splitEntriesLongerThan(Seq<TSEntry<T>> entries, long entryMaxLength) {
        return (Seq)entries.flatMap((Function1 & Serializable)entry -> entry.splitEntriesLongerThan(entryMaxLength).entries());
    }

    public <T> Seq<TSEntry<T>> sample(Seq<TSEntry<T>> entries, long start, long sampleRate, boolean useClosestInWindow) {
        return this.rec$1(start, entries.toStream(), sampleRate, useClosestInWindow);
    }

    public <T> TimeDomain unionLooseDomains(Seq<TimeSeries<T>> tss) {
        return (TimeDomain)((IterableOnceOps)tss.map((Function1 & Serializable)x$34 -> x$34.looseDomain())).fold((Object)EmptyTimeDomain$.MODULE$, (Function2 & Serializable)(x$35, x$36) -> x$35.looseUnion((TimeDomain)x$36));
    }

    public <T> TimeDomain intersectLooseDomains(Seq<TimeSeries<T>> tss) {
        return tss.isEmpty() ? EmptyTimeDomain$.MODULE$ : (TimeDomain)((IterableOnceOps)tss.map((Function1 & Serializable)x$37 -> x$37.looseDomain())).reduce((Function2 & Serializable)(x$38, x$39) -> x$38.intersect((TimeDomain)x$39));
    }

    public <T> TimeSeries<T> ofOrderedEntriesUnsafe(Seq<TSEntry<T>> xs, boolean isCompressed, boolean isDomainContinous) {
        int size = xs.size();
        return size == 0 ? EmptyTimeSeries$.MODULE$ : (size == 1 ? (TimeSeries)xs.head() : VectorTimeSeries$.MODULE$.ofOrderedEntriesUnsafe(xs, isCompressed, isDomainContinous));
    }

    public <T> boolean ofOrderedEntriesUnsafe$default$2() {
        return false;
    }

    public <T> boolean ofOrderedEntriesUnsafe$default$3() {
        return false;
    }

    public <T> TimeSeries<T> ofOrderedEntriesSafe(Seq<TSEntry<T>> xs, boolean compress) {
        return ((TimeSeriesBuilder)xs.foldLeft(this.newBuilder(compress), (Function2 & Serializable)(x$40, x$41) -> x$40.$plus$eq(x$41))).result();
    }

    public <T> boolean ofOrderedEntriesSafe$default$2() {
        return true;
    }

    public <T> TimeSeries<T> apply(Seq<TSEntry<T>> entries) {
        return this.ofOrderedEntriesSafe((Seq)entries.sorted(TSEntry$.MODULE$.orderByTs()), this.ofOrderedEntriesSafe$default$2());
    }

    public <T> TimeSeriesBuilder<T> newBuilder(boolean compress) {
        return new VectorTimeSeries.Builder(compress);
    }

    public <T> boolean newBuilder$default$1() {
        return true;
    }

    private static final boolean tooFarToTake$1(TSEntry next, long samplePoint, boolean useClosestInWindow$1, long sampleRate$1) {
        return useClosestInWindow$1 ? next.timestamp() > samplePoint + sampleRate$1 / 2L : next.timestamp() > samplePoint;
    }

    private final Stream rec$1(long samplePoint, Stream remaining, long sampleRate$1, boolean useClosestInWindow$1) {
        Stream stream;
        while (true) {
            TSEntry last;
            SeqOps seqOps;
            Option option;
            TSEntry next;
            Option option2;
            SeqOps seqOps2;
            Stream stream2;
            if ((stream2 = remaining) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Stream().unapplySeq((SeqOps)stream2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
                stream = (Stream)package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
                break;
            }
            if (stream2 != null && !(option2 = package$.MODULE$.$plus$colon().unapply((SeqOps)stream2)).isEmpty() && TimeSeries$.tooFarToTake$1(next = (TSEntry)((Tuple2)option2.get())._1(), samplePoint, useClosestInWindow$1, sampleRate$1)) {
                samplePoint += sampleRate$1;
                continue;
            }
            if (stream2 != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)stream2)).isEmpty()) {
                Option option3;
                TSEntry current = (TSEntry)((Tuple2)option.get())._1();
                Stream stream3 = (Stream)((Tuple2)option.get())._2();
                if (stream3 != null && !(option3 = package$.MODULE$.$plus$colon().unapply((SeqOps)stream3)).isEmpty()) {
                    TSEntry next2 = (TSEntry)((Tuple2)option3.get())._1();
                    if (!useClosestInWindow$1 && samplePoint < current.definedUntil() || useClosestInWindow$1 && (samplePoint < current.definedUntil() && next2.timestamp() > samplePoint + sampleRate$1 / 2L || Math.abs(current.timestamp() - samplePoint) < Math.abs(next2.timestamp() - samplePoint))) {
                        TSEntry tSEntry = new TSEntry(samplePoint, current.value(), sampleRate$1);
                        stream = Stream.Deferrer$.MODULE$.$hash$colon$colon$extension(Stream$.MODULE$.toDeferrer((Function0 & Serializable)() -> this.rec$1(samplePoint + sampleRate$1, remaining, sampleRate$1, useClosestInWindow$1)), tSEntry);
                        break;
                    }
                }
            }
            if (stream2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)stream2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && samplePoint < (last = (TSEntry)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)).definedUntil()) {
                TSEntry tSEntry = new TSEntry(samplePoint, last.value(), sampleRate$1);
                stream = Stream.Deferrer$.MODULE$.$hash$colon$colon$extension(Stream$.MODULE$.toDeferrer((Function0 & Serializable)() -> this.rec$1(samplePoint + sampleRate$1, remaining, sampleRate$1, useClosestInWindow$1)), tSEntry);
                break;
            }
            remaining = (Stream)remaining.tail();
        }
        return stream;
    }

    private TimeSeries$() {
    }
}

