/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.stats;

import io.sqooba.oss.timeseries.stats.Stats;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction1;

public final class UniformDoubleSnapshot$ {
    public static final UniformDoubleSnapshot$ MODULE$ = new UniformDoubleSnapshot$();

    public Stats computeStats(double[] reservoir, double min, double max) {
        Arrays.sort(reservoir);
        double avg = this.mean(reservoir);
        return new Stats(min, max, avg, this.stdDev(reservoir, avg), this.getValue(reservoir, 0.5));
    }

    public double mean(double[] reservoir) {
        double d;
        if (reservoir.length == 0) {
            d = 0.0;
        } else {
            DoubleRef sum = DoubleRef.create((double)0.0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(reservoir), (Function1)(JFunction1.mcVD.sp & Serializable)v -> sum$1.elem += v);
            d = sum.elem / (double)reservoir.length;
        }
        return d;
    }

    public double stdDev(double[] reservoir, double mean) {
        double d;
        if (reservoir.length <= 1) {
            d = 0.0;
        } else {
            DoubleRef sum = DoubleRef.create((double)0.0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(reservoir), (Function1)(JFunction1.mcVD.sp & Serializable)v -> {
                double diff = v - mean;
                sum$2.elem += diff * diff;
            });
            d = Math.sqrt(sum.elem / (double)(reservoir.length - 1));
        }
        return d;
    }

    public double getValue(double[] reservoir, double quantile) {
        double d;
        if (reservoir.length == 0) {
            d = 0.0;
        } else {
            double pos = quantile * (double)(reservoir.length + 1);
            int idx = (int)pos;
            if (idx < 1) {
                d = reservoir[0];
            } else if (idx >= reservoir.length) {
                d = reservoir[reservoir.length - 1];
            } else {
                double lower = reservoir[idx - 1];
                double upper = reservoir[idx];
                d = lower + (pos - Math.floor(pos)) * (upper - lower);
            }
        }
        return d;
    }

    private UniformDoubleSnapshot$() {
    }
}

