/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.utils;

import io.sqooba.oss.timeseries.utils.SliceableByteChannel;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u001d4Aa\u0004\t\u00057!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!A\u0004A!A!\u0002\u0013\u0011\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B \u0001\t\u0003\u0002\u0005\"B#\u0001\t\u00131\u0005\"B$\u0001\t\u0003B\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"\u0002,\u0001\t\u0003:\u0006\"\u0002,\u0001\t\u0003B\u0006bB.\u0001\u0005\u0004%\tE\u0012\u0005\u00079\u0002\u0001\u000b\u0011\u0002\u001a\t\u000bu\u0003A\u0011\t0\t\u000b\t\u0004A\u0011I2\u00037\u0011+g-Y;miNc\u0017nY3bE2,')\u001f;f\u0007\"\fgN\\3m\u0015\t\t\"#A\u0003vi&d7O\u0003\u0002\u0014)\u0005QA/[7fg\u0016\u0014\u0018.Z:\u000b\u0005U1\u0012aA8tg*\u0011q\u0003G\u0001\u0007gF|wNY1\u000b\u0003e\t!![8\u0004\u0001M\u0019\u0001\u0001\b\u0013\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u00027b]\u001eT\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\t1qJ\u00196fGR\u0004\"!\n\u0014\u000e\u0003AI!a\n\t\u0003)Mc\u0017nY3bE2,')\u001f;f\u0007\"\fgN\\3m\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0011\rD\u0017M\u001c8fYNT!A\f\u0011\u0002\u00079Lw.\u0003\u00021W\t\u00192+Z3lC\ndWMQ=uK\u000eC\u0017M\u001c8fY\u0006!aM]8n!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0011auN\\4\u0002\u0005Q|\u0017A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\u0013\u0001\u0011\u0015AC\u00011\u0001*\u0011\u0015\tD\u00011\u00013\u0011\u0015AD\u00011\u00013\u0003\u0015\u0019H.[2f)\r!\u0013i\u0011\u0005\u0006\u0005\u0016\u0001\rAM\u0001\u000bMJ|Wn\u00144gg\u0016$\b\"\u0002#\u0006\u0001\u0004\u0011\u0014\u0001\u0003;p\u001f\u001a47/\u001a;\u0002\u0013I,W.Y5oS:<W#\u0001\u001a\u0002\tI,\u0017\r\u001a\u000b\u0003\u00132\u0003\"a\r&\n\u0005-#$aA%oi\")Qj\u0002a\u0001\u001d\u0006\u0019Am\u001d;\u0011\u0005=\u0003V\"A\u0017\n\u0005Ek#A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006)qO]5uKR\u0011\u0011\n\u0016\u0005\u0006+\"\u0001\rAT\u0001\u0004gJ\u001c\u0017\u0001\u00039pg&$\u0018n\u001c8\u0015\u0003I\"\"\u0001J-\t\u000biS\u0001\u0019\u0001\u001a\u0002\u00179,w\u000fU8tSRLwN\\\u0001\u0005g&TX-A\u0003tSj,\u0007%\u0001\u0004jg>\u0003XM\u001c\u000b\u0002?B\u00111\u0007Y\u0005\u0003CR\u0012qAQ8pY\u0016\fg.A\u0003dY>\u001cX\rF\u0001e!\t\u0019T-\u0003\u0002gi\t!QK\\5u\u0001")
public class DefaultSliceableByteChannel
implements SliceableByteChannel {
    private final SeekableByteChannel channel;
    private final long from;
    private final long to;
    private final long size;

    @Override
    public SeekableByteChannel truncate(long size) {
        return SliceableByteChannel.truncate$(this, size);
    }

    @Override
    public int readIntFromEnd(long offsetToEnd) {
        return SliceableByteChannel.readIntFromEnd$(this, offsetToEnd);
    }

    @Override
    public byte[] readBytesFromEnd(long offsetToEnd, int length) {
        return SliceableByteChannel.readBytesFromEnd$(this, offsetToEnd, length);
    }

    @Override
    public byte[] readBytes(long offset, int length) {
        return SliceableByteChannel.readBytes$(this, offset, length);
    }

    @Override
    public SliceableByteChannel slice(long fromOffset, long toOffset) {
        return new DefaultSliceableByteChannel(this.channel, this.from + fromOffset, this.from + toOffset);
    }

    private long remaining() {
        return this.size() - this.position();
    }

    @Override
    public int read(ByteBuffer dst) {
        int n;
        if (this.remaining() == 0L) {
            n = -1;
        } else {
            Object object = (long)dst.remaining() > this.remaining() ? dst.limit((int)this.remaining()) : BoxedUnit.UNIT;
            n = this.channel.read(dst);
        }
        return n;
    }

    @Override
    public int write(ByteBuffer src) {
        int n;
        if (this.remaining() == 0L) {
            n = -1;
        } else {
            Object object = (long)src.remaining() > this.remaining() ? src.limit((int)this.remaining()) : BoxedUnit.UNIT;
            n = this.channel.write(src);
        }
        return n;
    }

    @Override
    public long position() {
        return this.channel.position() - this.from;
    }

    @Override
    public SliceableByteChannel position(long newPosition) {
        if (newPosition + this.from > this.to) {
            throw new IndexOutOfBoundsException(new StringBuilder(44).append("The new position ").append(newPosition).append(" was larger than the size ").append(this.size()).append(".").toString());
        }
        this.channel.position(this.from + newPosition);
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public DefaultSliceableByteChannel(SeekableByteChannel channel, long from, long to) {
        this.channel = channel;
        this.from = from;
        this.to = to;
        SliceableByteChannel.$init$(this);
        Predef$.MODULE$.require(from >= 0L, (Function0 & Serializable)() -> "Start of the slice cannot be negative.");
        Predef$.MODULE$.require(to >= from, (Function0 & Serializable)() -> "The end of the slice needs to be larger than its start.");
        Predef$.MODULE$.require(to <= channel.size(), (Function0 & Serializable)() -> "The end of the slice cannot be larger than the channel.");
        channel.position(from);
        this.size = to - from;
    }
}

