/*
 * Decompiled with CFR 0.152.
 */
package io.sqooba.oss.timeseries.immutable;

import io.sqooba.oss.timeseries.TimeSeries;
import io.sqooba.oss.timeseries.immutable.EmptyTimeSeries$;
import io.sqooba.oss.timeseries.immutable.TSEntry;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Numeric;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TSEntry$mcV$sp
extends TSEntry<BoxedUnit> {
    public final BoxedUnit value$mcV$sp;

    @Override
    public void value$mcV$sp() {
    }

    @Override
    public void value() {
        this.value$mcV$sp();
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryRight(long at) {
        return this.trimEntryRight$mcV$sp(at);
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryRight$mcV$sp(long at) {
        if (at <= this.timestamp()) {
            throw new IllegalArgumentException(new StringBuilder(65).append("Attempting to trim right at ").append(at).append(" before entry's domain has started (").append(this.timestamp()).append(")").toString());
        }
        return at >= this.definedUntil() ? this : new TSEntry$mcV$sp(this.timestamp(), BoxedUnit.UNIT, at - this.timestamp());
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryLeft(long at) {
        return this.trimEntryLeft$mcV$sp(at);
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryLeft$mcV$sp(long at) {
        if (at >= this.definedUntil()) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Attempting to trim left at ").append(at).append(" after entry's domain has ended (").append(this.definedUntil()).append(")").toString());
        }
        return at <= this.timestamp() ? this : new TSEntry$mcV$sp(at, BoxedUnit.UNIT, this.definedUntil() - at);
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryLeftNRight(long l, long r) {
        return this.trimEntryLeftNRight$mcV$sp(l, r);
    }

    @Override
    public TSEntry<BoxedUnit> trimEntryLeftNRight$mcV$sp(long l, long r) {
        TSEntry$mcV$sp tSEntry$mcV$sp;
        if (l >= this.definedUntil()) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Attempting to trim left at ").append(l).append(" after entry's domain has ended (").append(this.definedUntil()).append(")").toString());
        }
        if (r <= this.timestamp()) {
            throw new IllegalArgumentException(new StringBuilder(65).append("Attempting to trim right at ").append(r).append(" before entry's domain has started (").append(this.timestamp()).append(")").toString());
        }
        if (l >= r) {
            throw new IllegalArgumentException(new StringBuilder(60).append("Left time must be strictly lower than right time. Was: ").append(l).append(" and ").append(r).toString());
        }
        if (l <= this.timestamp() && r >= this.definedUntil()) {
            tSEntry$mcV$sp = this;
        } else {
            long start = Math.max(this.timestamp(), l);
            tSEntry$mcV$sp = new TSEntry$mcV$sp(start, BoxedUnit.UNIT, Math.min(this.definedUntil(), r) - start);
        }
        return tSEntry$mcV$sp;
    }

    @Override
    public <O> TSEntry<O> map(Function1<BoxedUnit, O> f, boolean compress, TypeTags.WeakTypeTag<O> evidence$1) {
        return this.map$mcV$sp(f, compress, evidence$1);
    }

    @Override
    public <O> TSEntry<O> map$mcV$sp(Function1<BoxedUnit, O> f, boolean compress, TypeTags.WeakTypeTag<O> evidence$1) {
        return new TSEntry<Object>(this.timestamp(), f.apply((Object)BoxedUnit.UNIT), this.validity());
    }

    @Override
    public <O> TSEntry<O> mapEntries(Function1<TSEntry<BoxedUnit>, O> f, boolean compress, TypeTags.WeakTypeTag<O> evidence$2) {
        return this.mapEntries$mcV$sp(f, compress, evidence$2);
    }

    @Override
    public <O> TSEntry<O> mapEntries$mcV$sp(Function1<TSEntry<BoxedUnit>, O> f, boolean compress, TypeTags.WeakTypeTag<O> evidence$2) {
        Object x$1 = f.apply((Object)this);
        long x$2 = this.copy$default$1();
        long x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public TimeSeries<BoxedUnit> filterEntries(Function1<TSEntry<BoxedUnit>, Object> predicate) {
        return this.filterEntries$mcV$sp(predicate);
    }

    @Override
    public TimeSeries<BoxedUnit> filterEntries$mcV$sp(Function1<TSEntry<BoxedUnit>, Object> predicate) {
        return BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)this)) ? this : EmptyTimeSeries$.MODULE$;
    }

    @Override
    public <U> TimeSeries<U> fill(U whenUndef) {
        return this.fill$mcV$sp(whenUndef);
    }

    @Override
    public <U> TimeSeries<U> fill$mcV$sp(U whenUndef) {
        return this;
    }

    @Override
    public <U> Seq<TSEntry<U>> appendEntry(TSEntry<U> other, boolean compress) {
        return this.appendEntry$mcV$sp(other, compress);
    }

    @Override
    public <U> Seq<TSEntry<U>> appendEntry$mcV$sp(TSEntry<U> other, boolean compress) {
        return other.timestamp() <= this.timestamp() ? (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{other})) : this.extendOrTrim$mcV$sp(other, compress);
    }

    @Override
    public <U> boolean appendEntry$default$2() {
        return this.appendEntry$default$2$mcV$sp();
    }

    @Override
    public <U> boolean appendEntry$default$2$mcV$sp() {
        return true;
    }

    @Override
    public <U> Seq<TSEntry<U>> extendOrTrim(TSEntry<U> other, boolean compress) {
        return this.extendOrTrim$mcV$sp(other, compress);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <U> Seq<TSEntry<U>> extendOrTrim$mcV$sp(TSEntry<U> other, boolean compress) {
        Seq seq;
        if (compress && other.timestamp() <= this.definedUntil()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            U u = other.value();
            if (!(boxedUnit != null ? !boxedUnit.equals(u) : u != null)) {
                long extension = other.definedUntil() - this.definedUntil();
                if (extension < 0L) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{this.trimEntryRight$mcV$sp(other.definedUntil())}));
                    return seq;
                }
                seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{this.extendValidity$mcV$sp(other.definedUntil() - this.definedUntil())}));
                return seq;
            }
        }
        seq = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{this.trimEntryRight$mcV$sp(other.timestamp()), other}));
        return seq;
    }

    @Override
    public <U> Seq<TSEntry<U>> prependEntry(TSEntry<U> other) {
        return this.prependEntry$mcV$sp(other);
    }

    @Override
    public <U> Seq<TSEntry<U>> prependEntry$mcV$sp(TSEntry<U> other) {
        return other.timestamp() >= this.definedUntil() ? (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{other})) : (other.definedUntil() < this.definedUntil() ? (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{other, this.trimEntryLeft$mcV$sp(other.definedUntil())})) : (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TSEntry[]{other})));
    }

    @Override
    public TSEntry<BoxedUnit> head() {
        return this.head$mcV$sp();
    }

    @Override
    public TSEntry<BoxedUnit> head$mcV$sp() {
        return this;
    }

    @Override
    public TSEntry<BoxedUnit> last() {
        return this.last$mcV$sp();
    }

    @Override
    public TSEntry<BoxedUnit> last$mcV$sp() {
        return this;
    }

    @Override
    public TSEntry<BoxedUnit> extendValidity(long validityIncrement) {
        return this.extendValidity$mcV$sp(validityIncrement);
    }

    @Override
    public TSEntry<BoxedUnit> extendValidity$mcV$sp(long validityIncrement) {
        if (validityIncrement < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("Cannot reduce validity of an entry (").append(this).append(") with increment ").append(validityIncrement).append(".").toString());
        }
        return validityIncrement == 0L ? this : new TSEntry$mcV$sp(this.timestamp(), BoxedUnit.UNIT, this.validity() + validityIncrement);
    }

    @Override
    public <U> double integral(TimeUnit timeUnit, Numeric<U> n) {
        return this.integral$mcV$sp(timeUnit, n);
    }

    @Override
    public <U> double integral$mcV$sp(TimeUnit timeUnit, Numeric<U> n) {
        return (double)TimeUnit.MILLISECONDS.convert(this.validity(), timeUnit) / 1000.0 * n.toDouble((Object)BoxedUnit.UNIT);
    }

    @Override
    public <U> TimeUnit integral$default$1() {
        return this.integral$default$1$mcV$sp();
    }

    @Override
    public <U> TimeUnit integral$default$1$mcV$sp() {
        return TimeUnit.MILLISECONDS;
    }

    @Override
    public <U> TSEntry<Object> integralEntry(TimeUnit timeUnit, Numeric<U> n) {
        return this.integralEntry$mcV$sp(timeUnit, n);
    }

    @Override
    public <U> TSEntry<Object> integralEntry$mcV$sp(TimeUnit timeUnit, Numeric<U> n) {
        return this.map$mcV$sp((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)this.integral$mcV$sp(timeUnit, n)), this.map$default$2(), ((TypeTags)package$.MODULE$.universe()).WeakTypeTag().Double());
    }

    @Override
    public <U> TimeUnit integralEntry$default$1() {
        return this.integralEntry$default$1$mcV$sp();
    }

    @Override
    public <U> TimeUnit integralEntry$default$1$mcV$sp() {
        return TimeUnit.MILLISECONDS;
    }

    @Override
    public <T> void copy$default$2() {
        this.copy$default$2$mcV$sp();
    }

    @Override
    public <T> void copy$default$2$mcV$sp() {
        this.value();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public TSEntry$mcV$sp(long timestamp, BoxedUnit value$mcV$sp, long validity) {
        this.value$mcV$sp = value$mcV$sp;
        super(timestamp, BoxedUnit.UNIT, validity);
    }
}

