/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import com.google.common.base.Suppliers;
import io.squashql.jdbc.JdbcDatastore;
import io.squashql.jdbc.JdbcUtil;
import io.squashql.store.Store;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Supplier;
import org.duckdb.DuckDBConnection;

public class DuckDBDatastore
implements JdbcDatastore {
    private final DuckDBConnection connection;
    public final Supplier<Map<String, Store>> stores;

    public DuckDBDatastore() {
        try {
            Class.forName("org.duckdb.DuckDBDriver");
            this.connection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
            String schema = this.connection.getSchema();
            String catalog = this.connection.getCatalog();
            this.stores = Suppliers.memoize(() -> JdbcUtil.getStores((String)catalog, (String)schema, (Connection)this.getConnection(), JdbcUtil::sqlTypeToClass));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection() {
        try {
            return this.connection.duplicate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Store> storesByName() {
        return this.stores.get();
    }
}

