/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import io.squashql.DuckDBDatastore;
import io.squashql.jdbc.JdbcUtil;
import io.squashql.table.Table;
import io.squashql.transaction.DataLoader;
import io.squashql.type.TableTypedField;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl;

public class DuckDBDataLoader
implements DataLoader {
    private final DuckDBDatastore datastore;

    public DuckDBDataLoader(DuckDBDatastore datastore) {
        this.datastore = datastore;
    }

    public void createOrReplaceTable(String tableName, Table table) {
        List<TableTypedField> fields = table.headers().stream().map(h -> new TableTypedField(tableName, h.name(), h.type())).toList();
        DuckDBDataLoader.createOrReplaceTable(this.datastore, tableName, fields, false);
        this.loadWithOrWithoutScenario(null, tableName, table.iterator());
    }

    public void createOrReplaceTable(String tableName, List<TableTypedField> fields) {
        this.createOrReplaceTable(tableName, fields, true);
    }

    public void createOrReplaceTable(String tableName, List<TableTypedField> fields, boolean cjMode) {
        DuckDBDataLoader.createOrReplaceTable(this.datastore, tableName, fields, cjMode);
    }

    public static void createOrReplaceTable(DuckDBDatastore datastore, String tableName, List<TableTypedField> fields, boolean cjMode) {
        List list = cjMode ? ImmutableListFactoryImpl.INSTANCE.ofAll(fields).newWith((Object)new TableTypedField(tableName, "scenario", String.class)).castToList() : fields;
        try (Connection conn = datastore.getConnection();
             Statement stmt = conn.createStatement();){
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TableTypedField field = (TableTypedField)list.get(i);
                sb.append("\"").append(field.name()).append("\" ").append(JdbcUtil.classToSqlType((Class)field.type()));
                if (i >= size - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            stmt.execute("create or replace table \"" + tableName + "\"" + sb + ";");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(String scenario, String table, List<Object[]> tuples) {
        this.loadWithOrWithoutScenario(scenario, table, tuples.stream().map(t -> Arrays.asList(t)).toList().iterator());
    }

    private void loadWithOrWithoutScenario(String scenario, String table, Iterator<List<Object>> tuplesIterator) {
        if (scenario != null && !scenario.equals("base")) {
            this.ensureScenarioColumnIsPresent(table);
        }
        boolean addScenario = this.scenarioColumnIsPresent(table);
        String sql = "insert into \"" + table + "\" values ";
        try (Connection conn = this.datastore.getConnection();
             Statement stmt = conn.createStatement();){
            while (tuplesIterator.hasNext()) {
                List<Object> tuple = tuplesIterator.next();
                StringBuilder sb = new StringBuilder();
                sb.append('(');
                for (int i = 0; i < tuple.size(); ++i) {
                    Object o = tuple.get(i);
                    if (o != null && (o.getClass().equals(LocalDate.class) || o.getClass().equals(LocalDateTime.class))) {
                        o = o.toString();
                    }
                    if (o instanceof String) {
                        sb.append('\'').append(o).append('\'');
                    } else {
                        sb.append(o);
                    }
                    sb.append(",");
                }
                if (addScenario) {
                    sb.append('\'').append(scenario).append('\'').append("),");
                    sql = sql + sb.toString();
                    continue;
                }
                String s = sb.toString();
                sql = sql + s.substring(0, s.length() - 1) + "),";
            }
            stmt.execute(sql.substring(0, sql.length() - 1));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureScenarioColumnIsPresent(String store) {
        List fields = this.datastore.storesByName().get(store).fields();
        boolean found = fields.stream().anyMatch(f -> f.name().equals("scenario"));
        if (!found) {
            throw new RuntimeException(String.format("%s field not found", "scenario"));
        }
    }

    private boolean scenarioColumnIsPresent(String store) {
        List fields = this.datastore.storesByName().get(store).fields();
        return fields.stream().anyMatch(f -> f.name().equals("scenario"));
    }

    public void loadCsv(String scenario, String table, String path, String delimiter, boolean header) {
        throw new RuntimeException("Not implemented");
    }
}

