/*
 * Decompiled with CFR 0.152.
 */
package io.squashql;

import io.squashql.jdbc.JdbcUtil;
import io.squashql.list.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class PostgreSQLUtil {
    private PostgreSQLUtil() {
    }

    public static String classToPostgreSQLType(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "text";
        }
        if (clazz.equals(Double.TYPE)) {
            return "double precision";
        }
        if (clazz.equals(Lists.LongList.class)) {
            return "integer[]";
        }
        if (clazz.equals(Lists.StringList.class)) {
            return "varchar[]";
        }
        if (clazz.equals(Object.class)) {
            return "json";
        }
        return JdbcUtil.classToSqlType(clazz);
    }

    public static Class<?> getJavaClass(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        String columnTypeName = metaData.getColumnTypeName(columnIndex);
        String columnClassName = metaData.getColumnClassName(columnIndex);
        if (columnTypeName.equals("numeric")) {
            return columnClassName.equals(BigDecimal.class.getName()) ? BigDecimal.class : BigInteger.class;
        }
        return PostgreSQLUtil.getJavaClass(metaData.getColumnType(columnIndex), columnTypeName);
    }

    public static Class<?> getJavaClass(int dataType, String columnTypeName) {
        if (columnTypeName.equals("numeric")) {
            return BigDecimal.class;
        }
        if (columnTypeName.equals("_int4") || columnTypeName.equals("_int8") || columnTypeName.equals("_numeric")) {
            return Lists.LongList.class;
        }
        if (columnTypeName.equals("_float4") || columnTypeName.equals("_float8")) {
            return Lists.DoubleList.class;
        }
        if (columnTypeName.equals("_varchar")) {
            return Lists.StringList.class;
        }
        if (columnTypeName.equals("_date")) {
            return Lists.LocalDateList.class;
        }
        return JdbcUtil.sqlTypeToClass((int)dataType);
    }
}

