/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.query.database;

import io.squashql.query.BinaryOperator;
import io.squashql.query.database.QueryRewriter;
import io.squashql.query.database.SqlFunctions;
import io.squashql.query.database.SqlUtils;
import io.squashql.type.FunctionTypedField;
import io.squashql.type.TypedField;

class PostgreSQLQueryRewriter
implements QueryRewriter {
    PostgreSQLQueryRewriter() {
    }

    public String tableName(String table) {
        return SqlUtils.doubleQuoteEscape((String)table);
    }

    public String cteName(String cteName) {
        return SqlUtils.doubleQuoteEscape((String)cteName);
    }

    public String fieldName(String field) {
        return SqlUtils.doubleQuoteEscape((String)field);
    }

    public String escapeAlias(String alias) {
        return SqlUtils.doubleQuoteEscape((String)alias);
    }

    public boolean usePartialRollupSyntax() {
        return true;
    }

    public boolean useAliasInHavingClause() {
        return false;
    }

    public String functionExpression(FunctionTypedField ftf) {
        if ("current_date".contains(ftf.function())) {
            return "CURRENT_DATE";
        }
        if (SqlFunctions.SUPPORTED_DATE_FUNCTIONS.contains(ftf.function())) {
            return String.format("extract(%s from %s)", ftf.function(), ftf.field().sqlExpression((QueryRewriter)this));
        }
        return super.functionExpression(ftf);
    }

    public String binaryOperation(BinaryOperator operator, String leftOperand, String rightOperand) {
        return switch (operator) {
            case BinaryOperator.DIVIDE -> leftOperand + " " + operator.infix + " " + String.format("NULLIF(%s,0)", rightOperand);
            default -> super.binaryOperation(operator, leftOperand, rightOperand);
        };
    }

    public String arrayContains(TypedField field, Object value) {
        return String.format("%s=ANY(%s)", value, field.sqlExpression((QueryRewriter)this));
    }
}

