/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.transaction;

import io.squashql.PostgreSQLDatastore;
import io.squashql.PostgreSQLUtil;
import io.squashql.jackson.JacksonUtil;
import io.squashql.transaction.DataLoader;
import io.squashql.type.TableTypedField;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.postgresql.util.PGobject;

public class PostgreSQLDataLoader
implements DataLoader {
    protected final PostgreSQLDatastore datastore;

    public void dropAndCreateInMemoryTable(String table, List<TableTypedField> fields) {
        PostgreSQLDataLoader.dropAndCreateInMemoryTable(this.datastore, table, fields);
    }

    public static void dropAndCreateInMemoryTable(PostgreSQLDatastore datastore, String table, List<TableTypedField> fields) {
        try (Connection conn = datastore.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("drop table if exists " + table);
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            for (TableTypedField field : fields) {
                joiner.add("\"" + field.name() + "\" " + PostgreSQLUtil.classToPostgreSQLType(field.type()));
            }
            stmt.execute("create table " + table + joiner);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(String table, List<Object[]> tuples) {
        String join = String.join((CharSequence)",", IntStream.range(0, tuples.get(0).length).mapToObj(i -> "?").toList());
        String pattern = "insert into " + table + " values(" + join + ")";
        try (Connection conn = this.datastore.getConnection();
             PreparedStatement stmt = conn.prepareStatement(pattern);){
            for (Object[] tuple : tuples) {
                for (int i2 = 0; i2 < tuple.length; ++i2) {
                    Object o = tuple[i2];
                    TableTypedField field = (TableTypedField)this.datastore.storeByName().get(table).fields().get(i2);
                    if (PostgreSQLUtil.classToPostgreSQLType(field.type()).equals("json")) {
                        PGobject pGobject = new PGobject();
                        pGobject.setType("json");
                        pGobject.setValue(JacksonUtil.serialize((Object)o));
                        o = pGobject;
                    }
                    stmt.setObject(i2 + 1, o);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadCsv(String table, String path, String delimiter, boolean header) {
        throw new RuntimeException("not implemented");
    }

    public void dropTables(Collection<String> tables) {
        try (Connection conn = this.datastore.getConnection();
             Statement stmt = conn.createStatement();){
            for (String table : tables) {
                stmt.execute("drop table if exists " + table);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public PostgreSQLDataLoader(PostgreSQLDatastore datastore) {
        this.datastore = datastore;
    }
}

