/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.client;

import io.staticcdn.sdk.client.model.OptimizeRequest;
import io.staticcdn.sdk.client.model.OptimizeScanRule;
import io.staticcdn.sdk.client.model.OptimizerOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeRequestBuilder {
    private static Logger logger = Logger.getLogger(OptimizeRequestBuilder.class.getName());
    OptimizeRequest optimizeRequest = new OptimizeRequest();
    Map<String, File> path2fileMapping;

    public OptimizeRequestBuilder(Map<String, File> path2fileMapping) {
        this.path2fileMapping = path2fileMapping;
    }

    public OptimizeRequest build() {
        return this.optimizeRequest;
    }

    public OptimizeRequestBuilder options(OptimizerOptions optimizerOptions) {
        this.optimizeRequest.setOptimizerOptions(optimizerOptions);
        return this;
    }

    public OptimizeRequestBuilder paths(Map<String, String> paths) {
        this.optimizeRequest.setPaths(paths);
        return this;
    }

    public OptimizeRequestBuilder collectFiles(List<OptimizeScanRule> optimizeScanRules, List<File> inputWwwRoots, String filePath) throws Exception {
        if (!this.collectSingleFile(optimizeScanRules, inputWwwRoots, filePath)) {
            throw new IllegalArgumentException("cannot find file: " + filePath);
        }
        return this;
    }

    private boolean collectSingleFile(List<OptimizeScanRule> optimizeScanRules, List<File> inputWwwRoots, String filePath) throws Exception {
        if (filePath == null) {
            return false;
        }
        if (filePath.indexOf(63) > 0) {
            filePath = filePath.substring(0, filePath.indexOf(63));
        }
        if (filePath.indexOf(35) > 0) {
            filePath = filePath.substring(0, filePath.indexOf(35));
        }
        filePath = filePath.replaceAll("\\\\", "/");
        if (this.optimizeRequest.getPaths().containsKey(filePath)) {
            return true;
        }
        for (File inputWwwRoot : inputWwwRoots) {
            File inputFile = new File(inputWwwRoot, filePath);
            if (!inputFile.isFile()) continue;
            String key = DigestUtils.md5Hex((InputStream)OptimizeRequestBuilder.checkForUtf8BOMAndDiscardIfAny(new FileInputStream(inputFile))) + "." + FilenameUtils.getExtension((String)inputFile.getName());
            this.optimizeRequest.addPath(filePath, key);
            this.path2fileMapping.put(filePath, inputFile);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("collected file " + filePath + " : " + key);
            }
            for (OptimizeScanRule optimizeScanRule : optimizeScanRules) {
                if (!Pattern.compile(optimizeScanRule.getExtensionPattern()).matcher(inputFile.getName()).find()) continue;
                String fileText = FileUtils.readFileToString((File)inputFile, (String)"UTF-8");
                Matcher urlMatcher = Pattern.compile(optimizeScanRule.getUrlPattern()).matcher(fileText);
                while (urlMatcher.find()) {
                    this.collectFoundUrl(optimizeScanRules, inputWwwRoots, inputWwwRoot, inputFile, urlMatcher.group(optimizeScanRule.getUrlGroupIndex()));
                }
            }
            return true;
        }
        return false;
    }

    private void collectFoundUrl(List<OptimizeScanRule> optimizeScanRules, List<File> inputWwwRoots, File inputWwwRoot, File inputFile, String foundUrl) throws Exception {
        if (!foundUrl.startsWith("data:") && foundUrl.indexOf("//") < 0) {
            boolean fileFound;
            if (foundUrl.indexOf("?") > 0) {
                foundUrl = foundUrl.substring(0, foundUrl.indexOf("?"));
            }
            if (foundUrl.indexOf("#") > 0) {
                foundUrl = foundUrl.substring(0, foundUrl.indexOf("#"));
            }
            if (foundUrl.charAt(0) == '/') {
                String embedPath = foundUrl;
                fileFound = this.collectSingleFile(optimizeScanRules, inputWwwRoots, embedPath);
            } else {
                File embedFile = new File(inputFile.getParentFile(), foundUrl);
                String embedPath = embedFile.getAbsolutePath().substring(inputWwwRoot.getAbsolutePath().length());
                fileFound = this.collectSingleFile(optimizeScanRules, inputWwwRoots, embedPath = FilenameUtils.normalize((String)embedPath));
                if (!fileFound) {
                    embedPath = "/" + foundUrl;
                    embedPath = FilenameUtils.normalize((String)embedPath);
                    fileFound = this.collectSingleFile(optimizeScanRules, inputWwwRoots, embedPath);
                }
            }
            if (!fileFound) {
                logger.warning("referenced file " + foundUrl + " not found in " + inputFile.getAbsolutePath());
            }
        }
    }

    public static InputStream checkForUtf8BOMAndDiscardIfAny(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }
}

