/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.client;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.staticcdn.sdk.client.OptimizeRequestBuilder;
import io.staticcdn.sdk.client.model.ErrorResponse;
import io.staticcdn.sdk.client.model.FilesInfoResponse;
import io.staticcdn.sdk.client.model.OptimizeRequest;
import io.staticcdn.sdk.client.model.OptimizeResponse;
import io.staticcdn.sdk.client.model.OptimizerOptions;
import io.staticcdn.sdk.client.model.ServerConfig;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticCdnClient {
    private static Logger logger = Logger.getLogger(StaticCdnClient.class.getName());
    private HttpResponse lastResponse;
    private String lastResponseTextBody;
    private HttpClient httpClient;
    private ServerConfig serverConfig;
    private List<String> apiServerList;
    private String clientUserAgent;

    public static void main(String[] args) {
        for (Object key : System.getProperties().keySet()) {
            System.out.println(key + ":" + System.getProperty((String)key));
        }
    }

    public StaticCdnClient() {
        this(null, null);
    }

    public StaticCdnClient(String apiKey, String apiSecret) {
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.handle-redirects", (Object)false);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)httpParams);
        this.httpClient = defaultHttpClient;
        this.setupCredentials(apiKey, apiSecret, defaultHttpClient);
        this.setupUserAgent();
        this.setupServerConfig();
    }

    public OptimizeResponse optimize(List<File> inputWwwRoots, File outputWwwRoot, String filePath, OptimizerOptions optimizerOptions, String originalFileNameSuffix, String refsFileNameSuffix) throws Exception {
        if (outputWwwRoot == null) {
            outputWwwRoot = inputWwwRoots.get(0);
        }
        this.backupExistingInputFile(inputWwwRoots, outputWwwRoot, filePath, originalFileNameSuffix);
        HashMap<String, File> path2fileMapping = new HashMap<String, File>();
        OptimizeRequest optimizeRequest = new OptimizeRequestBuilder(path2fileMapping).options(optimizerOptions).collectFiles(this.serverConfig.getOptimizeScanRules(), inputWwwRoots, filePath).build();
        OptimizeResponse optimizeResponse = this.optimize(inputWwwRoots, optimizeRequest);
        this.writeOptimizedResultToFile(outputWwwRoot, filePath, optimizeResponse, refsFileNameSuffix);
        return optimizeResponse;
    }

    public OptimizeResponse optimize(List<File> inputWwwRoots, OptimizeRequest optimizeRequest) throws Exception {
        OptimizeResponse optimizeResponse;
        long startTimestamp = System.currentTimeMillis();
        try {
            optimizeResponse = this.performOptimize(inputWwwRoots, optimizeRequest);
        }
        catch (Throwable ex) {
            if (ex.getMessage() == null || ex instanceof JsonSyntaxException) {
                logger.severe("last response was " + this.lastResponse.getStatusLine().getReasonPhrase() + " body: " + this.readTextBody());
            }
            throw new Exception("Failed to optimize files: " + ex.getMessage(), ex);
        }
        logger.info("optimized " + optimizeRequest.getPaths().keySet().iterator().next() + " in " + (double)(System.currentTimeMillis() - startTimestamp) / 1000.0 + " seconds");
        return optimizeResponse;
    }

    private ServerConfig apiCallConfig() {
        for (String apiServerUrl : this.apiServerList) {
            try {
                this.executeRequest((HttpUriRequest)new HttpGet(apiServerUrl + "/v1/config"), true);
                Gson gson = new Gson();
                return (ServerConfig)gson.fromJson(this.readTextBody(), ServerConfig.class);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "failed to retrieve server config from " + apiServerUrl + ": " + ex.getMessage());
            }
        }
        throw new RuntimeException("failed to retrieve server config");
    }

    private OptimizeResponse apiCallOptimize(OptimizeRequest optimizeRequest, Gson gson) throws Exception {
        Exception lastException = null;
        for (String apiServerUrl : this.apiServerList) {
            try {
                HttpPost request = new HttpPost(apiServerUrl + "/v1/optimizer/optimize");
                String requestBody = gson.toJson((Object)optimizeRequest);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("request body: " + requestBody);
                }
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.create((String)"application/json", (String)"UTF-8")));
                this.executeRequest((HttpUriRequest)request, true);
                return (OptimizeResponse)gson.fromJson(this.readTextBody(), OptimizeResponse.class);
            }
            catch (Exception ex) {
                if (this.lastResponse != null && this.lastResponse.getStatusLine().getStatusCode() < 500) {
                    throw ex;
                }
                logger.log(Level.WARNING, "failed to optimize with server " + apiServerUrl + ": " + ex.getMessage());
                lastException = ex;
            }
        }
        throw lastException;
    }

    private FilesInfoResponse apiCallUpload(List<File> inputWwwRoots, Map<String, String> path2keyMapping, List<String> keys, Gson gson) throws Exception {
        HashMap<String, String> key2pathMapping = new HashMap<String, String>();
        for (Map.Entry<String, String> pathAndKey : path2keyMapping.entrySet()) {
            key2pathMapping.put(pathAndKey.getValue(), pathAndKey.getKey());
        }
        Exception lastException = null;
        for (String apiServerUrl : this.apiServerList) {
            try {
                HttpPost request = new HttpPost(apiServerUrl + "/v1/files/upload");
                MultipartEntity multipartEntity = new MultipartEntity();
                ArrayList<String> missingPaths = new ArrayList<String>();
                block4: for (String missingKey : keys) {
                    for (File inputWwwRoot : inputWwwRoots) {
                        String filePath;
                        File localFile = new File(inputWwwRoot, filePath = (String)key2pathMapping.get(missingKey));
                        if (!localFile.isFile()) continue;
                        missingPaths.add(filePath);
                        multipartEntity.addPart("file", (ContentBody)new FileBody(localFile));
                        multipartEntity.addPart("key", (ContentBody)new StringBody(missingKey));
                        continue block4;
                    }
                }
                request.setEntity((HttpEntity)multipartEntity);
                this.executeRequest((HttpUriRequest)request, true);
                logger.info("uploaded " + StringUtils.join(missingPaths, (char)','));
                return (FilesInfoResponse)gson.fromJson(this.readTextBody(), FilesInfoResponse.class);
            }
            catch (Exception ex) {
                if (this.lastResponse != null && this.lastResponse.getStatusLine().getStatusCode() < 500) {
                    throw ex;
                }
                logger.log(Level.WARNING, "failed upload to server " + apiServerUrl + ": " + ex.getMessage());
                lastException = ex;
            }
        }
        throw lastException;
    }

    private OptimizeResponse performOptimize(List<File> inputWwwRoots, OptimizeRequest optimizeRequest) throws Exception {
        Gson gson = new Gson();
        OptimizeResponse optimizeResponse = this.apiCallOptimize(optimizeRequest, gson);
        if (optimizeResponse.getCreatedAt() == null) {
            if (optimizeResponse.getMissingKeys() != null) {
                this.apiCallUpload(inputWwwRoots, optimizeRequest.getPaths(), optimizeResponse.getMissingKeys(), gson);
                optimizeResponse = this.apiCallOptimize(optimizeRequest, gson);
            }
            if (optimizeResponse.getCreatedAt() == null) {
                throw new RuntimeException(optimizeResponse.getMessage());
            }
        }
        return optimizeResponse;
    }

    private void writeOptimizedResultToFile(File outputWwwRoot, String filePath, OptimizeResponse optimizeResponse, String refsFileNameSuffix) throws Exception {
        String fileExtension = FilenameUtils.getExtension((String)filePath);
        String fileBaseName = FilenameUtils.getBaseName((String)filePath);
        File outputFile = this.buildOutputFile(outputWwwRoot, filePath);
        FileUtils.writeStringToFile((File)outputFile, (String)optimizeResponse.getOptimized(), (String)"UTF-8");
        logger.info("optimized session " + optimizeResponse.getSignature() + " to " + outputFile.getAbsolutePath());
        if (!refsFileNameSuffix.equals("skip")) {
            StringBuilder refText = new StringBuilder();
            refText.append("session=" + optimizeResponse.getSignature() + "\n");
            if (optimizeResponse.getReferences() != null) {
                for (String referenceKey : optimizeResponse.getReferences().keySet()) {
                    refText.append(referenceKey + "=" + optimizeResponse.getReferences().get(referenceKey) + "\n");
                }
            }
            File refOutputFile = new File(outputFile.getAbsolutePath() + refsFileNameSuffix);
            FileUtils.writeStringToFile((File)refOutputFile, (String)refText.toString());
        }
    }

    private void backupExistingInputFile(List<File> inputWwwRoots, File outputWwwRoot, String filePath, String originalFileNameSuffix) throws Exception {
        if (!originalFileNameSuffix.equals("skip")) {
            for (File inputWwwRoot : inputWwwRoots) {
                File inputFile = new File(inputWwwRoot, filePath);
                if (!inputFile.exists()) continue;
                File outputFile = this.buildOutputFile(outputWwwRoot, filePath);
                File backupOriginFile = new File(outputFile.getAbsolutePath() + originalFileNameSuffix);
                if (!backupOriginFile.exists()) {
                    FileUtils.copyFile((File)inputFile, (File)backupOriginFile);
                    logger.fine("back up existing output file as:" + backupOriginFile.getAbsolutePath());
                }
                return;
            }
        }
    }

    private File buildOutputFile(File outputWwwRoot, String filePath) throws Exception {
        File outputFile = new File(outputWwwRoot, filePath);
        return outputFile;
    }

    public synchronized HttpResponse executeGet(String path) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpGet(this.apiServerList.get(0) + path), false);
    }

    public synchronized HttpResponse executeRequest(HttpUriRequest request, boolean verifyStatusOk) throws Exception {
        if (this.lastResponse != null) {
            if (this.lastResponseTextBody == null) {
                try {
                    this.lastResponse.getEntity().getContent().close();
                }
                catch (Exception ex) {
                    logger.warning("close previous connection failed with message: " + ex.getMessage());
                }
            }
            this.lastResponse = null;
        }
        this.lastResponseTextBody = null;
        URI uri = request.getURI();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("executing request " + request.getMethod() + ": " + uri);
        }
        BasicAuthCache authCache = new BasicAuthCache();
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        authCache.put(targetHost, (AuthScheme)new BasicScheme());
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        request.setHeader("User-Agent", this.clientUserAgent);
        this.lastResponse = this.httpClient.execute(targetHost, (HttpRequest)request, (HttpContext)localContext);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("executed request with response " + this.lastResponse.getStatusLine().getReasonPhrase() + " body: " + this.readTextBody());
        }
        if (verifyStatusOk && this.lastResponse.getStatusLine().getStatusCode() != 200) {
            String errorMessage = null;
            try {
                ErrorResponse errorResponse = (ErrorResponse)new Gson().fromJson(this.readTextBody(), ErrorResponse.class);
                if (errorResponse.getMessage() != null) {
                    errorMessage = errorResponse.getMessage();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (errorMessage == null) {
                errorMessage = request.getMethod() + " : " + uri + " failed with status code " + this.lastResponse.getStatusLine().getStatusCode();
            }
            throw new RuntimeException(errorMessage);
        }
        return this.lastResponse;
    }

    private void setupCredentials(String apiKey, String apiSecret, DefaultHttpClient defaultHttpClient) {
        if (StringUtils.isEmpty((CharSequence)apiKey) && StringUtils.isEmpty((CharSequence)(apiKey = System.getenv("STATIC_CDN_API_KEY"))) && StringUtils.isEmpty((CharSequence)(apiKey = System.getProperty("staticCdnApiKey")))) {
            apiKey = "anonymous";
        }
        if (StringUtils.isEmpty((CharSequence)apiSecret) && StringUtils.isEmpty((CharSequence)(apiSecret = System.getenv("STATIC_CDN_API_SECRET"))) && StringUtils.isEmpty((CharSequence)(apiSecret = System.getProperty("staticCdnApiSecret")))) {
            apiSecret = "none";
        }
        defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(apiKey, apiSecret));
    }

    private void setupUserAgent() {
        String clientVersion = "unknown";
        try {
            for (String line : IOUtils.readLines((InputStream)this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/io.staticcdn.sdk/staticcdn-sdk-client/pom.properties"))) {
                if (!line.startsWith("version=")) continue;
                clientVersion = line.substring(line.indexOf("=") + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clientUserAgent = "staticcdn-sdk-client " + clientVersion + " (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version") + ")";
    }

    private void setupServerConfig() {
        this.apiServerList = new ArrayList<String>();
        if (System.getProperty("staticCdnApiServerBaseUrl") != null) {
            this.apiServerList.add(System.getProperty("staticCdnApiServerBaseUrl"));
            this.serverConfig = this.apiCallConfig();
        } else {
            this.apiServerList.add("https://api.staticcdn.io");
            this.apiServerList.add("https://primary-api.staticcdn.io");
            this.apiServerList.add("https://backup-api.staticcdn.io");
            this.serverConfig = this.apiCallConfig();
            this.apiServerList = this.serverConfig.getApiServerList();
        }
    }

    public HttpResponse getLastResponse() {
        return this.lastResponse;
    }

    public List<String> getApiServerList() {
        return this.apiServerList;
    }

    public String readTextBody() throws Exception {
        if (this.lastResponseTextBody == null) {
            this.lastResponseTextBody = EntityUtils.toString((HttpEntity)this.lastResponse.getEntity());
        }
        return this.lastResponseTextBody;
    }
}

