/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.client;

import io.staticcdn.sdk.client.model.MimeType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class MimeTypeResolver {
    private Map<String, MimeType> extensionToMimeMap = new LinkedHashMap<String, MimeType>();
    private Map<String, String> contentTypeToExtensionMap = new HashMap<String, String>();

    public MimeTypeResolver() {
        this.extensionToMimeMap.put("js", new MimeType("application/javascript", true, "js"));
        this.extensionToMimeMap.put("json", new MimeType("application/json", true, "json"));
        this.extensionToMimeMap.put("xml", new MimeType("application/xml", true, "xml"));
        for (MimeType mimeType : this.extensionToMimeMap.values()) {
            if (this.contentTypeToExtensionMap.containsKey(mimeType.getExtension())) continue;
            this.contentTypeToExtensionMap.put(this.normalizeContentType(mimeType.getContentType()), mimeType.getExtension());
        }
        this.loadFromMimeTypeFile();
    }

    private void loadFromMimeTypeFile() {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream("mime.types");
            for (String line : IOUtils.readLines((InputStream)resourceAsStream)) {
                String[] lineInfo;
                if ((line = line.trim()).length() <= 0 || line.indexOf(35) == 0 || (lineInfo = line.split("\\s")).length <= 0) continue;
                String contentType = null;
                for (String segment : lineInfo) {
                    if (segment.length() <= 0) continue;
                    if (contentType == null) {
                        contentType = segment;
                        continue;
                    }
                    this.addMimeType(contentType, segment);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to load mime.types file", ex);
        }
    }

    private void addMimeType(String contentType, String extension) {
        if (!this.contentTypeToExtensionMap.containsKey(contentType = this.normalizeContentType(contentType))) {
            this.contentTypeToExtensionMap.put(contentType, extension);
        }
        if (!this.extensionToMimeMap.containsKey(extension)) {
            boolean isText = contentType.indexOf("text") == 0 || contentType.indexOf("xml") >= 0;
            MimeType mimeType = new MimeType(contentType, isText, extension);
            this.extensionToMimeMap.put(extension, mimeType);
        }
    }

    private String normalizeContentType(String contentType) {
        if (contentType.indexOf(";") > 0) {
            contentType = contentType.substring(0, contentType.indexOf(";"));
        }
        contentType = contentType.toLowerCase().trim();
        return contentType;
    }

    public MimeType resolveMime(String fileName) {
        return this.resolveMimeByExtension(FilenameUtils.getExtension((String)fileName));
    }

    public MimeType resolveMimeByExtension(String fileExtension) {
        return this.extensionToMimeMap.get(fileExtension.toLowerCase());
    }

    public MimeType resolveMimeByContentType(String contentType) {
        String ext = this.contentTypeToExtensionMap.get(this.normalizeContentType(contentType));
        if (ext != null) {
            return this.extensionToMimeMap.get(ext);
        }
        return null;
    }
}

