/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.client;

import io.staticcdn.sdk.client.model.OptimiseRequest;
import io.staticcdn.sdk.client.model.OptimiseScanRule;
import io.staticcdn.sdk.client.model.OptimiserOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimiseRequestBuilder {
    private static Logger logger = Logger.getLogger(OptimiseRequestBuilder.class.getName());
    OptimiseRequest optimiseRequest = new OptimiseRequest();
    Map<String, File> path2fileMapping;

    public OptimiseRequestBuilder(Map<String, File> path2fileMapping) {
        this.path2fileMapping = path2fileMapping;
    }

    public OptimiseRequest build() {
        return this.optimiseRequest;
    }

    public OptimiseRequestBuilder options(OptimiserOptions optimiserOptions) {
        this.optimiseRequest.setOptimiserOptions(optimiserOptions);
        return this;
    }

    public OptimiseRequestBuilder paths(Map<String, String> paths) {
        this.optimiseRequest.setPaths(paths);
        return this;
    }

    public OptimiseRequestBuilder collectFiles(List<OptimiseScanRule> optimiseScanRules, List<File> inputWwwRoots, String filePath) throws Exception {
        this.collectSingleFile(optimiseScanRules, inputWwwRoots, filePath, true);
        return this;
    }

    private void collectSingleFile(List<OptimiseScanRule> optimiseScanRules, List<File> inputWwwRoots, String filePath, boolean isConfiguredFile) throws Exception {
        if (filePath == null) {
            return;
        }
        if (filePath.indexOf(63) > 0) {
            filePath = filePath.substring(0, filePath.indexOf(63));
        }
        if (filePath.indexOf(35) > 0) {
            filePath = filePath.substring(0, filePath.indexOf(35));
        }
        filePath = filePath.replaceAll("\\\\", "/");
        if (this.optimiseRequest.getPaths().containsKey(filePath)) {
            return;
        }
        for (File inputWwwRoot : inputWwwRoots) {
            File inputFile = new File(inputWwwRoot, filePath);
            if (!inputFile.isFile()) continue;
            String key = DigestUtils.md5Hex((InputStream)OptimiseRequestBuilder.checkForUtf8BOMAndDiscardIfAny(new FileInputStream(inputFile))) + "." + FilenameUtils.getExtension((String)inputFile.getName());
            this.optimiseRequest.addPath(filePath, key);
            this.path2fileMapping.put(filePath, inputFile);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("collected file " + filePath + " : " + key);
            }
            for (OptimiseScanRule optimiseScanRule : optimiseScanRules) {
                if (!Pattern.compile(optimiseScanRule.getExtensionPattern()).matcher(inputFile.getName()).find()) continue;
                String fileText = FileUtils.readFileToString((File)inputFile, (String)"UTF-8");
                Matcher urlMatcher = Pattern.compile(optimiseScanRule.getUrlPattern()).matcher(fileText);
                while (urlMatcher.find()) {
                    this.collectFoundUrl(optimiseScanRules, inputWwwRoots, inputWwwRoot, inputFile, urlMatcher.group(optimiseScanRule.getUrlGroupIndex()));
                }
            }
            return;
        }
        if (isConfiguredFile) {
            throw new IllegalArgumentException("cannot find file: " + filePath);
        }
        logger.warning("file " + filePath + " not found for " + this.optimiseRequest.getPaths().keySet().iterator().next());
    }

    private void collectFoundUrl(List<OptimiseScanRule> optimiseScanRules, List<File> inputWwwRoots, File inputWwwRoot, File inputFile, String foundUrl) throws Exception {
        if (!foundUrl.startsWith("data:") && foundUrl.indexOf("//") < 0) {
            String embedPath;
            if (foundUrl.indexOf("?") > 0) {
                foundUrl = foundUrl.substring(0, foundUrl.indexOf("?"));
            }
            if (foundUrl.indexOf("#") > 0) {
                foundUrl = foundUrl.substring(0, foundUrl.indexOf("#"));
            }
            if (foundUrl.charAt(0) == '/') {
                embedPath = foundUrl;
            } else {
                File embedFile = new File(inputFile.getParentFile(), foundUrl);
                embedPath = embedFile.getAbsolutePath().substring(inputWwwRoot.getAbsolutePath().length());
                embedPath = FilenameUtils.normalize((String)embedPath);
            }
            this.collectSingleFile(optimiseScanRules, inputWwwRoots, embedPath, false);
        }
    }

    public static InputStream checkForUtf8BOMAndDiscardIfAny(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }
}

