/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.maven;

import io.staticcdn.sdk.client.StaticCdnClient;
import io.staticcdn.sdk.client.model.OptimizerOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="optimize", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class OptimizeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File buildOutputDirectory;
    @Parameter(required=true)
    private List<File> inputWwwRoots;
    @Parameter
    private File outputWwwRoot;
    @Parameter
    private List<String> inputFileRelativePaths;
    @Parameter
    private List<String> inputFilePathPatterns;
    @Parameter
    private OptimizerOptions optimizerOptions;
    @Parameter(defaultValue="false", property="skipOptimize")
    private boolean skipOptimize;
    @Parameter(defaultValue=".origin")
    private String originalFileNameSuffix;
    @Parameter(defaultValue=".refs")
    private String refsFileNameSuffix;
    @Parameter
    private String apiKey;
    @Parameter
    private String apiSecret;

    public void execute() throws MojoExecutionException {
        if (this.skipOptimize) {
            this.getLog().info((CharSequence)"optimize skipped");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            Logger rootLogger = Logger.getAnonymousLogger().getParent();
            rootLogger.setLevel(Level.FINE);
            for (Handler handler : rootLogger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                ((ConsoleHandler)handler).setLevel(Level.FINE);
            }
        }
        if (this.inputFileRelativePaths == null) {
            if (this.inputFilePathPatterns != null) {
                this.inputFileRelativePaths = new ArrayList<String>();
            } else {
                throw new MojoExecutionException("you must set inputFileRelativePaths or inputFilePathPattern");
            }
        }
        if (this.inputFilePathPatterns != null) {
            for (File inputWwwRoot : this.inputWwwRoots) {
                if (!inputWwwRoot.isDirectory()) continue;
                for (File foundFile : FileUtils.listFiles((File)inputWwwRoot, null, (boolean)true)) {
                    String relativePath = foundFile.getAbsolutePath().substring(inputWwwRoot.getAbsolutePath().length());
                    relativePath = relativePath.replaceAll("\\\\", "/");
                    for (String filePathPattern : this.inputFilePathPatterns) {
                        if (!relativePath.matches(filePathPattern) || this.inputFileRelativePaths.contains(relativePath)) continue;
                        this.inputFileRelativePaths.add(relativePath);
                    }
                }
            }
        }
        if (this.inputFileRelativePaths.size() == 0) {
            throw new MojoExecutionException("no file found to optimize");
        }
        StaticCdnClient staticCdnClient = new StaticCdnClient(this.apiKey, this.apiSecret);
        for (String filePath : this.inputFileRelativePaths) {
            try {
                staticCdnClient.optimize(this.inputWwwRoots, this.outputWwwRoot, filePath, this.optimizerOptions, this.originalFileNameSuffix, this.refsFileNameSuffix);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

