/*
 *  Copyright 2019 <---> Present Status Machina Contributors (https://github.com/entzik/status-machina/graphs/contributors)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  This software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 *  CONDITIONS OF ANY KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations under the License.
 *
 */

package io.statusmachina.spring.jpa.configuration;

import io.statusmachina.spring.jpa.autoconfig.StatusMachinaProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
public class TransactionTemplateCnfiguration {
    public static final String STATUS_MACHINA_TRANSACTION_TEMPLATE = "status-machina-transaction-template";

    @Autowired
    PlatformTransactionManager platformTransactionManager;

    @Autowired
    StatusMachinaProperties config;

    @Bean(STATUS_MACHINA_TRANSACTION_TEMPLATE)
    public TransactionTemplate buildTransactionTemplate() {
        final TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
        transactionTemplate.setIsolationLevel(config.getTransactionIsolation());
        transactionTemplate.setPropagationBehavior(config.getTransactionPropagation());
        return transactionTemplate;
    }
}
