package io.stigg.api.client;

import javax.annotation.Nonnull;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
public class ClientConfig {
  @Nonnull String apiKey;
  @Builder.Default String apiUrl = "https://api.stigg.io/graphql";
  @Builder.Default String edgeApiUrl = "https://edge.api.stigg.io";
  @Builder.Default Boolean disableEdge = false;
  @Builder.Default Long requestConnectTimeoutMs = 30000L;
  @Builder.Default Long requestReadTimeoutMs = 30000L;
}
