/*
 * Decompiled with CFR 0.152.
 */
package io.stigg.api.client;

import javax.annotation.Nonnull;

public final class ClientConfig {
    @Nonnull
    private final String apiKey;
    private final String apiUrl;
    private final String edgeApiUrl;
    private final Boolean disableEdge;
    private final Long requestConnectTimeoutMs;
    private final Long requestReadTimeoutMs;

    private static String $default$apiUrl() {
        return "https://api.stigg.io/graphql";
    }

    private static String $default$edgeApiUrl() {
        return "https://edge.api.stigg.io";
    }

    private static Boolean $default$disableEdge() {
        return false;
    }

    private static Long $default$requestConnectTimeoutMs() {
        return 30000L;
    }

    private static Long $default$requestReadTimeoutMs() {
        return 30000L;
    }

    ClientConfig(@Nonnull String apiKey, String apiUrl, String edgeApiUrl, Boolean disableEdge, Long requestConnectTimeoutMs, Long requestReadTimeoutMs) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.apiUrl = apiUrl;
        this.edgeApiUrl = edgeApiUrl;
        this.disableEdge = disableEdge;
        this.requestConnectTimeoutMs = requestConnectTimeoutMs;
        this.requestReadTimeoutMs = requestReadTimeoutMs;
    }

    public static ClientConfigBuilder builder() {
        return new ClientConfigBuilder();
    }

    @Nonnull
    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getEdgeApiUrl() {
        return this.edgeApiUrl;
    }

    public Boolean getDisableEdge() {
        return this.disableEdge;
    }

    public Long getRequestConnectTimeoutMs() {
        return this.requestConnectTimeoutMs;
    }

    public Long getRequestReadTimeoutMs() {
        return this.requestReadTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        Boolean this$disableEdge = this.getDisableEdge();
        Boolean other$disableEdge = other.getDisableEdge();
        if (this$disableEdge == null ? other$disableEdge != null : !((Object)this$disableEdge).equals(other$disableEdge)) {
            return false;
        }
        Long this$requestConnectTimeoutMs = this.getRequestConnectTimeoutMs();
        Long other$requestConnectTimeoutMs = other.getRequestConnectTimeoutMs();
        if (this$requestConnectTimeoutMs == null ? other$requestConnectTimeoutMs != null : !((Object)this$requestConnectTimeoutMs).equals(other$requestConnectTimeoutMs)) {
            return false;
        }
        Long this$requestReadTimeoutMs = this.getRequestReadTimeoutMs();
        Long other$requestReadTimeoutMs = other.getRequestReadTimeoutMs();
        if (this$requestReadTimeoutMs == null ? other$requestReadTimeoutMs != null : !((Object)this$requestReadTimeoutMs).equals(other$requestReadTimeoutMs)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$apiUrl = this.getApiUrl();
        String other$apiUrl = other.getApiUrl();
        if (this$apiUrl == null ? other$apiUrl != null : !this$apiUrl.equals(other$apiUrl)) {
            return false;
        }
        String this$edgeApiUrl = this.getEdgeApiUrl();
        String other$edgeApiUrl = other.getEdgeApiUrl();
        return !(this$edgeApiUrl == null ? other$edgeApiUrl != null : !this$edgeApiUrl.equals(other$edgeApiUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableEdge = this.getDisableEdge();
        result = result * 59 + ($disableEdge == null ? 43 : ((Object)$disableEdge).hashCode());
        Long $requestConnectTimeoutMs = this.getRequestConnectTimeoutMs();
        result = result * 59 + ($requestConnectTimeoutMs == null ? 43 : ((Object)$requestConnectTimeoutMs).hashCode());
        Long $requestReadTimeoutMs = this.getRequestReadTimeoutMs();
        result = result * 59 + ($requestReadTimeoutMs == null ? 43 : ((Object)$requestReadTimeoutMs).hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $apiUrl = this.getApiUrl();
        result = result * 59 + ($apiUrl == null ? 43 : $apiUrl.hashCode());
        String $edgeApiUrl = this.getEdgeApiUrl();
        result = result * 59 + ($edgeApiUrl == null ? 43 : $edgeApiUrl.hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfig(apiKey=" + this.getApiKey() + ", apiUrl=" + this.getApiUrl() + ", edgeApiUrl=" + this.getEdgeApiUrl() + ", disableEdge=" + this.getDisableEdge() + ", requestConnectTimeoutMs=" + this.getRequestConnectTimeoutMs() + ", requestReadTimeoutMs=" + this.getRequestReadTimeoutMs() + ")";
    }

    public static class ClientConfigBuilder {
        private String apiKey;
        private boolean apiUrl$set;
        private String apiUrl$value;
        private boolean edgeApiUrl$set;
        private String edgeApiUrl$value;
        private boolean disableEdge$set;
        private Boolean disableEdge$value;
        private boolean requestConnectTimeoutMs$set;
        private Long requestConnectTimeoutMs$value;
        private boolean requestReadTimeoutMs$set;
        private Long requestReadTimeoutMs$value;

        ClientConfigBuilder() {
        }

        public ClientConfigBuilder apiKey(@Nonnull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public ClientConfigBuilder apiUrl(String apiUrl) {
            this.apiUrl$value = apiUrl;
            this.apiUrl$set = true;
            return this;
        }

        public ClientConfigBuilder edgeApiUrl(String edgeApiUrl) {
            this.edgeApiUrl$value = edgeApiUrl;
            this.edgeApiUrl$set = true;
            return this;
        }

        public ClientConfigBuilder disableEdge(Boolean disableEdge) {
            this.disableEdge$value = disableEdge;
            this.disableEdge$set = true;
            return this;
        }

        public ClientConfigBuilder requestConnectTimeoutMs(Long requestConnectTimeoutMs) {
            this.requestConnectTimeoutMs$value = requestConnectTimeoutMs;
            this.requestConnectTimeoutMs$set = true;
            return this;
        }

        public ClientConfigBuilder requestReadTimeoutMs(Long requestReadTimeoutMs) {
            this.requestReadTimeoutMs$value = requestReadTimeoutMs;
            this.requestReadTimeoutMs$set = true;
            return this;
        }

        public ClientConfig build() {
            String apiUrl$value = this.apiUrl$value;
            if (!this.apiUrl$set) {
                apiUrl$value = ClientConfig.$default$apiUrl();
            }
            String edgeApiUrl$value = this.edgeApiUrl$value;
            if (!this.edgeApiUrl$set) {
                edgeApiUrl$value = ClientConfig.$default$edgeApiUrl();
            }
            Boolean disableEdge$value = this.disableEdge$value;
            if (!this.disableEdge$set) {
                disableEdge$value = ClientConfig.$default$disableEdge();
            }
            Long requestConnectTimeoutMs$value = this.requestConnectTimeoutMs$value;
            if (!this.requestConnectTimeoutMs$set) {
                requestConnectTimeoutMs$value = ClientConfig.$default$requestConnectTimeoutMs();
            }
            Long requestReadTimeoutMs$value = this.requestReadTimeoutMs$value;
            if (!this.requestReadTimeoutMs$set) {
                requestReadTimeoutMs$value = ClientConfig.$default$requestReadTimeoutMs();
            }
            return new ClientConfig(this.apiKey, apiUrl$value, edgeApiUrl$value, disableEdge$value, requestConnectTimeoutMs$value, requestReadTimeoutMs$value);
        }

        public String toString() {
            return "ClientConfig.ClientConfigBuilder(apiKey=" + this.apiKey + ", apiUrl$value=" + this.apiUrl$value + ", edgeApiUrl$value=" + this.edgeApiUrl$value + ", disableEdge$value=" + this.disableEdge$value + ", requestConnectTimeoutMs$value=" + this.requestConnectTimeoutMs$value + ", requestReadTimeoutMs$value=" + this.requestReadTimeoutMs$value + ")";
        }
    }
}

