/*
 * Decompiled with CFR 0.152.
 */
package io.stigg.api.client;

import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.okhttp.FailsafeCall;
import java.time.Duration;
import java.util.List;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class NetworkRequestUtils {
    static final String AUTH_HEADER = "X-API-KEY";
    private static final List<Integer> DO_NOT_RETRY_CODES = List.of(Integer.valueOf(400), Integer.valueOf(401), Integer.valueOf(403), Integer.valueOf(404), Integer.valueOf(500));

    NetworkRequestUtils() {
    }

    static FailsafeCall toFailsafeCall(OkHttpClient httpClient, Request request) {
        Call call = httpClient.newCall(request);
        RetryPolicy retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(NetworkRequestUtils::retryIf)).withMaxAttempts(5).withBackoff(Duration.ofMillis(500L), Duration.ofSeconds(2L)).withJitter(Duration.ofMillis(100L)).build();
        FailsafeExecutor failsafeExecutor = Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]);
        return FailsafeCall.with((FailsafeExecutor)failsafeExecutor).compose(call);
    }

    private static boolean retryIf(Response response, Throwable throwable) {
        if (response == null) {
            return throwable != null;
        }
        return !response.isSuccessful() && !DO_NOT_RETRY_CODES.contains(response.code());
    }
}

