package io.stigg.api.client;

import dev.failsafe.okhttp.FailsafeCall;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public class FailsafeCallAdapter implements Call {
  private final FailsafeCall failsafeCall;

  public FailsafeCallAdapter(FailsafeCall failsafeCall) {
    this.failsafeCall = failsafeCall;
  }

  @NotNull
  @Override
  public Request request() {
    throw new IllegalStateException("Not implemented");
  }

  @NotNull
  @Override
  public Response execute() throws IOException {
    return failsafeCall.execute();
  }

  @Override
  public void enqueue(@NotNull Callback callback) {
    throw new IllegalStateException("Not implemented");
  }

  @Override
  public void cancel() {
    failsafeCall.cancel();
  }

  @Override
  public boolean isExecuted() {
    return failsafeCall.isExecuted();
  }

  @Override
  public boolean isCanceled() {
    return failsafeCall.isCancelled();
  }

  @NotNull
  @Override
  public Timeout timeout() {
    throw new IllegalStateException("Not implemented");
  }

  @NotNull
  @Override
  public Call clone() {
    throw new IllegalStateException("Not implemented");
  }
}
