package io.stigg.api.client;

import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.RetryPolicy;
import dev.failsafe.okhttp.FailsafeCall;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class NetworkRequestUtils {

  static String AUTH_HEADER = "X-API-KEY";

  static FailsafeCall toFailsafeCall(OkHttpClient httpClient, Request request) {
    var call = httpClient.newCall(request);

    RetryPolicy<Response> retryPolicy =
        RetryPolicy.<Response>builder()
            .handle(ApolloHttpException.class, ApolloNetworkException.class)
            .withMaxAttempts(3)
            .withDelay(1, 3, TimeUnit.SECONDS.toChronoUnit())
            .build();
    FailsafeExecutor<Response> failsafeExecutor = Failsafe.with(retryPolicy);

    return FailsafeCall.with(failsafeExecutor).compose(call);
  }
}
