/*
 * Decompiled with CFR 0.152.
 */
package io.stigg.api.client;

import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Operations;
import dev.failsafe.okhttp.FailsafeCall;
import io.stigg.api.client.ClientConfig;
import io.stigg.api.client.NetworkRequestUtils;
import io.stigg.api.operations.GetActiveSubscriptionsListQuery;
import io.stigg.api.operations.GetEntitlementQuery;
import io.stigg.api.operations.GetEntitlementsQuery;
import io.stigg.api.operations.type.EntitlementOptions;
import io.stigg.api.operations.type.FetchEntitlementQuery;
import io.stigg.api.operations.type.FetchEntitlementsQuery;
import io.stigg.api.operations.type.GetActiveSubscriptionsInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

class EdgeApiClient {
    private static final String API_VERSION_HEADER = "X-API-VERSION";
    private static final String API_VERSION_VALUE = "1";
    private final ClientConfig config;
    private final OkHttpClient httpClient;

    EdgeApiClient(ClientConfig config, OkHttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    GetEntitlementsQuery.Data getEntitlements(GetEntitlementsQuery query) {
        FetchEntitlementsQuery params = query.query;
        String customerId = params.customerId;
        String resourceId = (String)params.resourceId.getOrNull();
        ArrayList<String> requestParams = new ArrayList<String>();
        if (resourceId != null) {
            requestParams.add("resourceId=" + resourceId);
        }
        String url = this.composeUrl("/v1/c/" + customerId + "/entitlements.json", requestParams);
        return (GetEntitlementsQuery.Data)this.exchange((Operation)query, url);
    }

    GetEntitlementQuery.Data getEntitlement(GetEntitlementQuery query) {
        FetchEntitlementQuery params = query.query;
        String customerId = params.customerId;
        String featureId = params.featureId;
        String resourceId = (String)params.resourceId.getOrNull();
        EntitlementOptions options = (EntitlementOptions)params.options.getOrNull();
        Double requestedUsage = options != null ? (Double)options.requestedUsage.getOrNull() : null;
        ArrayList<String> requestParams = new ArrayList<String>();
        requestParams.add("featureId=" + featureId);
        if (resourceId != null) {
            requestParams.add("resourceId=" + resourceId);
        }
        if (requestedUsage != null) {
            requestParams.add("requestedUsage=" + requestedUsage);
        }
        String url = this.composeUrl("/v1/c/" + customerId + "/entitlements.json", requestParams);
        return (GetEntitlementQuery.Data)this.exchange((Operation)query, url);
    }

    GetActiveSubscriptionsListQuery.Data getActiveSubscriptionsList(GetActiveSubscriptionsListQuery query) {
        GetActiveSubscriptionsInput params = query.input;
        String customerId = params.customerId;
        String resourceId = (String)params.resourceId.getOrNull();
        List resourceIds = (List)params.resourceIds.getOrNull();
        ArrayList<String> requestParams = new ArrayList<String>();
        if (resourceId != null) {
            requestParams.add("resourceId=" + resourceId);
        } else if (resourceIds != null) {
            resourceIds.forEach(resourceId2 -> requestParams.add("resourceIds=" + resourceId2));
        }
        String url = this.composeUrl("/v1/c/" + customerId + "/subscriptions.json", requestParams);
        return (GetActiveSubscriptionsListQuery.Data)this.exchange((Operation)query, url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <D extends Operation.Data> D exchange(Operation<D> operation, String url) {
        Request request = new Request.Builder().url(url).header("X-API-KEY", this.config.getApiKey()).header(API_VERSION_HEADER, API_VERSION_VALUE).build();
        FailsafeCall call = NetworkRequestUtils.toFailsafeCall(this.httpClient, request);
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                throw new RuntimeException(String.format("Operation %s via EdgeAPI failed: %s (%d)", operation.name(), response.message(), response.code()));
            }
            ResponseBody body = response.body();
            assert (body != null);
            ApolloResponse res = Operations.parseJsonResponse(operation, (String)body.string(), (CustomScalarAdapters)CustomScalarAdapters.Empty);
            Operation.Data data = res.dataAssertNoErrors();
            return (D)data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String composeUrl(String path, List<String> requestParams) {
        String base = this.composeUrl(path);
        return requestParams.isEmpty() ? base : base + "?" + String.join((CharSequence)"&", requestParams);
    }

    private String composeUrl(String path) {
        return this.config.getEdgeApiUrl() + path;
    }
}

