/*
 * Decompiled with CFR 0.152.
 */
package io.stigg.api.client;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.network.http.DefaultHttpEngine;
import com.apollographql.apollo3.network.http.HttpEngine;
import com.apollographql.apollo3.rx2.Rx2Apollo;
import io.stigg.api.client.ClientConfig;
import io.stigg.api.client.EdgeApiClient;
import io.stigg.api.client.FailsafeCallAdapter;
import io.stigg.api.client.GraphQLOperationInterceptor;
import io.stigg.api.client.NetworkRequestUtils;
import io.stigg.api.operations.GetActiveSubscriptionsListQuery;
import io.stigg.api.operations.GetEntitlementQuery;
import io.stigg.api.operations.GetEntitlementsQuery;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okhttp3.OkHttpClient;

public class Stigg {
    private final ClientConfig config;
    private final ApolloClient apolloClient;
    private final EdgeApiClient edgeApiClient;

    private Stigg(ClientConfig config) {
        this.config = config;
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(config.getRequestConnectTimeoutMs().longValue(), TimeUnit.MILLISECONDS).readTimeout(config.getRequestReadTimeoutMs().longValue(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).build();
        DefaultHttpEngine httpEngine = new DefaultHttpEngine(request -> new FailsafeCallAdapter(NetworkRequestUtils.toFailsafeCall(httpClient, request)));
        this.apolloClient = new ApolloClient.Builder().serverUrl(config.getApiUrl()).addHttpHeader("X-API-KEY", config.getApiKey()).addInterceptor((ApolloInterceptor)new GraphQLOperationInterceptor()).httpEngine((HttpEngine)httpEngine).build();
        this.edgeApiClient = new EdgeApiClient(config, httpClient);
        Runtime.getRuntime().addShutdownHook(new Thread(this::tryCloseClient));
    }

    public void close() {
        this.tryCloseClient();
    }

    private void tryCloseClient() {
        try {
            if (this.apolloClient != null) {
                this.apolloClient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <D extends Query.Data> D query(Query<D> query) {
        if (!this.config.getDisableEdge().booleanValue()) {
            if (query instanceof GetEntitlementsQuery) {
                return (D)this.edgeApiClient.getEntitlements((GetEntitlementsQuery)query);
            }
            if (query instanceof GetEntitlementQuery) {
                return (D)this.edgeApiClient.getEntitlement((GetEntitlementQuery)query);
            }
            if (query instanceof GetActiveSubscriptionsListQuery) {
                return (D)this.edgeApiClient.getActiveSubscriptionsList((GetActiveSubscriptionsListQuery)query);
            }
        }
        ApolloCall call = this.apolloClient.query(query);
        ApolloResponse result = (ApolloResponse)Rx2Apollo.single((ApolloCall)call).blockingGet();
        return (D)((Query.Data)result.dataAssertNoErrors());
    }

    public <D extends Mutation.Data> D mutation(Mutation<D> mutation) {
        ApolloCall call = this.apolloClient.mutation(mutation);
        ApolloResponse result = (ApolloResponse)Rx2Apollo.single((ApolloCall)call).blockingGet();
        return (D)((Mutation.Data)result.dataAssertNoErrors());
    }

    public static Stigg createClient(@Nonnull String apiKey) {
        Objects.requireNonNull(apiKey, "apiKey cannot be null");
        return Stigg.createClient(ClientConfig.builder().apiKey(apiKey).build());
    }

    public static Stigg createClient(@Nonnull ClientConfig config) {
        return new Stigg(config);
    }
}

