/*
 * Decompiled with CFR 0.152.
 */
package com.streamlayer.organizations.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.streamlayer.common.AccessLevel;
import com.streamlayer.organizations.common.OrganizationMemberOrBuilder;
import com.streamlayer.organizations.common.UserNotificationPreference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public final class OrganizationMember
extends GeneratedMessageLite<OrganizationMember, Builder>
implements OrganizationMemberOrBuilder {
    public static final int USERNAME_FIELD_NUMBER = 1;
    private String username_ = "";
    public static final int FIRST_NAME_FIELD_NUMBER = 2;
    private String firstName_ = "";
    public static final int LAST_NAME_FIELD_NUMBER = 3;
    private String lastName_ = "";
    public static final int PERMISSIONS_FIELD_NUMBER = 4;
    private Internal.IntList permissions_ = OrganizationMember.emptyIntList();
    private static final Internal.ListAdapter.Converter<Integer, AccessLevel> permissions_converter_;
    private int permissionsMemoizedSerializedSize;
    public static final int ACCEPTED_FIELD_NUMBER = 5;
    private String accepted_ = "";
    public static final int INVITED_FIELD_NUMBER = 6;
    private String invited_ = "";
    public static final int BANNED_FIELD_NUMBER = 7;
    private boolean banned_;
    public static final int AVATAR_FIELD_NUMBER = 8;
    private String avatar_ = "";
    public static final int AVATAR_BACKGROUND_COLOUR_FIELD_NUMBER = 9;
    private String avatarBackgroundColour_ = "";
    public static final int TIMEZONE_FIELD_NUMBER = 10;
    private String timezone_ = "";
    public static final int NOTIFICATION_PREFERENCE_FIELD_NUMBER = 11;
    private int notificationPreference_;
    private static final OrganizationMember DEFAULT_INSTANCE;
    private static volatile Parser<OrganizationMember> PARSER;

    private OrganizationMember() {
    }

    @Override
    public String getUsername() {
        return this.username_;
    }

    @Override
    public ByteString getUsernameBytes() {
        return ByteString.copyFromUtf8((String)this.username_);
    }

    private void setUsername(String value) {
        Class<?> valueClass = value.getClass();
        this.username_ = value;
    }

    private void clearUsername() {
        this.username_ = OrganizationMember.getDefaultInstance().getUsername();
    }

    private void setUsernameBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.username_ = value.toStringUtf8();
    }

    @Override
    public String getFirstName() {
        return this.firstName_;
    }

    @Override
    public ByteString getFirstNameBytes() {
        return ByteString.copyFromUtf8((String)this.firstName_);
    }

    private void setFirstName(String value) {
        Class<?> valueClass = value.getClass();
        this.firstName_ = value;
    }

    private void clearFirstName() {
        this.firstName_ = OrganizationMember.getDefaultInstance().getFirstName();
    }

    private void setFirstNameBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.firstName_ = value.toStringUtf8();
    }

    @Override
    public String getLastName() {
        return this.lastName_;
    }

    @Override
    public ByteString getLastNameBytes() {
        return ByteString.copyFromUtf8((String)this.lastName_);
    }

    private void setLastName(String value) {
        Class<?> valueClass = value.getClass();
        this.lastName_ = value;
    }

    private void clearLastName() {
        this.lastName_ = OrganizationMember.getDefaultInstance().getLastName();
    }

    private void setLastNameBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.lastName_ = value.toStringUtf8();
    }

    @Override
    public List<AccessLevel> getPermissionsList() {
        return new Internal.ListAdapter((List)this.permissions_, permissions_converter_);
    }

    @Override
    public int getPermissionsCount() {
        return this.permissions_.size();
    }

    @Override
    public AccessLevel getPermissions(int index) {
        AccessLevel result = AccessLevel.forNumber(this.permissions_.getInt(index));
        return result == null ? AccessLevel.UNRECOGNIZED : result;
    }

    @Override
    public List<Integer> getPermissionsValueList() {
        return this.permissions_;
    }

    @Override
    public int getPermissionsValue(int index) {
        return this.permissions_.getInt(index);
    }

    private void ensurePermissionsIsMutable() {
        Internal.IntList tmp = this.permissions_;
        if (!tmp.isModifiable()) {
            this.permissions_ = GeneratedMessageLite.mutableCopy((Internal.IntList)tmp);
        }
    }

    private void setPermissions(int index, AccessLevel value) {
        ((Object)((Object)value)).getClass();
        this.ensurePermissionsIsMutable();
        this.permissions_.setInt(index, value.getNumber());
    }

    private void addPermissions(AccessLevel value) {
        ((Object)((Object)value)).getClass();
        this.ensurePermissionsIsMutable();
        this.permissions_.addInt(value.getNumber());
    }

    private void addAllPermissions(Iterable<? extends AccessLevel> values) {
        this.ensurePermissionsIsMutable();
        for (AccessLevel accessLevel : values) {
            this.permissions_.addInt(accessLevel.getNumber());
        }
    }

    private void clearPermissions() {
        this.permissions_ = OrganizationMember.emptyIntList();
    }

    private void setPermissionsValue(int index, int value) {
        this.ensurePermissionsIsMutable();
        this.permissions_.setInt(index, value);
    }

    private void addPermissionsValue(int value) {
        this.ensurePermissionsIsMutable();
        this.permissions_.addInt(value);
    }

    private void addAllPermissionsValue(Iterable<Integer> values) {
        this.ensurePermissionsIsMutable();
        for (int value : values) {
            this.permissions_.addInt(value);
        }
    }

    @Override
    public String getAccepted() {
        return this.accepted_;
    }

    @Override
    public ByteString getAcceptedBytes() {
        return ByteString.copyFromUtf8((String)this.accepted_);
    }

    private void setAccepted(String value) {
        Class<?> valueClass = value.getClass();
        this.accepted_ = value;
    }

    private void clearAccepted() {
        this.accepted_ = OrganizationMember.getDefaultInstance().getAccepted();
    }

    private void setAcceptedBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.accepted_ = value.toStringUtf8();
    }

    @Override
    public String getInvited() {
        return this.invited_;
    }

    @Override
    public ByteString getInvitedBytes() {
        return ByteString.copyFromUtf8((String)this.invited_);
    }

    private void setInvited(String value) {
        Class<?> valueClass = value.getClass();
        this.invited_ = value;
    }

    private void clearInvited() {
        this.invited_ = OrganizationMember.getDefaultInstance().getInvited();
    }

    private void setInvitedBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.invited_ = value.toStringUtf8();
    }

    @Override
    public boolean getBanned() {
        return this.banned_;
    }

    private void setBanned(boolean value) {
        this.banned_ = value;
    }

    private void clearBanned() {
        this.banned_ = false;
    }

    @Override
    public String getAvatar() {
        return this.avatar_;
    }

    @Override
    public ByteString getAvatarBytes() {
        return ByteString.copyFromUtf8((String)this.avatar_);
    }

    private void setAvatar(String value) {
        Class<?> valueClass = value.getClass();
        this.avatar_ = value;
    }

    private void clearAvatar() {
        this.avatar_ = OrganizationMember.getDefaultInstance().getAvatar();
    }

    private void setAvatarBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.avatar_ = value.toStringUtf8();
    }

    @Override
    public String getAvatarBackgroundColour() {
        return this.avatarBackgroundColour_;
    }

    @Override
    public ByteString getAvatarBackgroundColourBytes() {
        return ByteString.copyFromUtf8((String)this.avatarBackgroundColour_);
    }

    private void setAvatarBackgroundColour(String value) {
        Class<?> valueClass = value.getClass();
        this.avatarBackgroundColour_ = value;
    }

    private void clearAvatarBackgroundColour() {
        this.avatarBackgroundColour_ = OrganizationMember.getDefaultInstance().getAvatarBackgroundColour();
    }

    private void setAvatarBackgroundColourBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.avatarBackgroundColour_ = value.toStringUtf8();
    }

    @Override
    public String getTimezone() {
        return this.timezone_;
    }

    @Override
    public ByteString getTimezoneBytes() {
        return ByteString.copyFromUtf8((String)this.timezone_);
    }

    private void setTimezone(String value) {
        Class<?> valueClass = value.getClass();
        this.timezone_ = value;
    }

    private void clearTimezone() {
        this.timezone_ = OrganizationMember.getDefaultInstance().getTimezone();
    }

    private void setTimezoneBytes(ByteString value) {
        OrganizationMember.checkByteStringIsUtf8((ByteString)value);
        this.timezone_ = value.toStringUtf8();
    }

    @Override
    public int getNotificationPreferenceValue() {
        return this.notificationPreference_;
    }

    @Override
    public UserNotificationPreference getNotificationPreference() {
        UserNotificationPreference result = UserNotificationPreference.forNumber(this.notificationPreference_);
        return result == null ? UserNotificationPreference.UNRECOGNIZED : result;
    }

    private void setNotificationPreferenceValue(int value) {
        this.notificationPreference_ = value;
    }

    private void setNotificationPreference(UserNotificationPreference value) {
        this.notificationPreference_ = value.getNumber();
    }

    private void clearNotificationPreference() {
        this.notificationPreference_ = 0;
    }

    public static OrganizationMember parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data);
    }

    public static OrganizationMember parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrganizationMember parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static OrganizationMember parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrganizationMember parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static OrganizationMember parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrganizationMember parseFrom(InputStream input) throws IOException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static OrganizationMember parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrganizationMember parseDelimitedFrom(InputStream input) throws IOException {
        return (OrganizationMember)OrganizationMember.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static OrganizationMember parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrganizationMember)OrganizationMember.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OrganizationMember parseFrom(CodedInputStream input) throws IOException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static OrganizationMember parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OrganizationMember)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(OrganizationMember prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new OrganizationMember();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"username_", "firstName_", "lastName_", "permissions_", "accepted_", "invited_", "banned_", "avatar_", "avatarBackgroundColour_", "timezone_", "notificationPreference_"};
                String info = "\u0000\u000b\u0000\u0000\u0001\u000b\u000b\u0000\u0001\u0000\u0001\u0208\u0002\u0208\u0003\u0208\u0004,\u0005\u0208\u0006\u0208\u0007\u0007\b\u0208\t\u0208\n\u0208\u000b\f";
                return OrganizationMember.newMessageInfo((MessageLite)DEFAULT_INSTANCE, (String)info, (Object[])objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                GeneratedMessageLite.DefaultInstanceBasedParser parser = PARSER;
                if (parser != null) return parser;
                Class<OrganizationMember> clazz = OrganizationMember.class;
                synchronized (OrganizationMember.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static OrganizationMember getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OrganizationMember> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        OrganizationMember defaultInstance;
        permissions_converter_ = new Internal.ListAdapter.Converter<Integer, AccessLevel>(){

            public AccessLevel convert(Integer from) {
                AccessLevel result = AccessLevel.forNumber(from);
                return result == null ? AccessLevel.UNRECOGNIZED : result;
            }
        };
        DEFAULT_INSTANCE = defaultInstance = new OrganizationMember();
        GeneratedMessageLite.registerDefaultInstance(OrganizationMember.class, (GeneratedMessageLite)defaultInstance);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<OrganizationMember, Builder>
    implements OrganizationMemberOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public String getUsername() {
            return ((OrganizationMember)this.instance).getUsername();
        }

        @Override
        public ByteString getUsernameBytes() {
            return ((OrganizationMember)this.instance).getUsernameBytes();
        }

        public Builder setUsername(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setUsername(value);
            return this;
        }

        public Builder clearUsername() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearUsername();
            return this;
        }

        public Builder setUsernameBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setUsernameBytes(value);
            return this;
        }

        @Override
        public String getFirstName() {
            return ((OrganizationMember)this.instance).getFirstName();
        }

        @Override
        public ByteString getFirstNameBytes() {
            return ((OrganizationMember)this.instance).getFirstNameBytes();
        }

        public Builder setFirstName(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setFirstName(value);
            return this;
        }

        public Builder clearFirstName() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearFirstName();
            return this;
        }

        public Builder setFirstNameBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setFirstNameBytes(value);
            return this;
        }

        @Override
        public String getLastName() {
            return ((OrganizationMember)this.instance).getLastName();
        }

        @Override
        public ByteString getLastNameBytes() {
            return ((OrganizationMember)this.instance).getLastNameBytes();
        }

        public Builder setLastName(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setLastName(value);
            return this;
        }

        public Builder clearLastName() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearLastName();
            return this;
        }

        public Builder setLastNameBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setLastNameBytes(value);
            return this;
        }

        @Override
        public List<AccessLevel> getPermissionsList() {
            return ((OrganizationMember)this.instance).getPermissionsList();
        }

        @Override
        public int getPermissionsCount() {
            return ((OrganizationMember)this.instance).getPermissionsCount();
        }

        @Override
        public AccessLevel getPermissions(int index) {
            return ((OrganizationMember)this.instance).getPermissions(index);
        }

        public Builder setPermissions(int index, AccessLevel value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setPermissions(index, value);
            return this;
        }

        public Builder addPermissions(AccessLevel value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).addPermissions(value);
            return this;
        }

        public Builder addAllPermissions(Iterable<? extends AccessLevel> values) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).addAllPermissions(values);
            return this;
        }

        public Builder clearPermissions() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearPermissions();
            return this;
        }

        @Override
        public List<Integer> getPermissionsValueList() {
            return Collections.unmodifiableList(((OrganizationMember)this.instance).getPermissionsValueList());
        }

        @Override
        public int getPermissionsValue(int index) {
            return ((OrganizationMember)this.instance).getPermissionsValue(index);
        }

        public Builder setPermissionsValue(int index, int value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setPermissionsValue(index, value);
            return this;
        }

        public Builder addPermissionsValue(int value) {
            ((OrganizationMember)this.instance).addPermissionsValue(value);
            return this;
        }

        public Builder addAllPermissionsValue(Iterable<Integer> values) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).addAllPermissionsValue(values);
            return this;
        }

        @Override
        public String getAccepted() {
            return ((OrganizationMember)this.instance).getAccepted();
        }

        @Override
        public ByteString getAcceptedBytes() {
            return ((OrganizationMember)this.instance).getAcceptedBytes();
        }

        public Builder setAccepted(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAccepted(value);
            return this;
        }

        public Builder clearAccepted() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearAccepted();
            return this;
        }

        public Builder setAcceptedBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAcceptedBytes(value);
            return this;
        }

        @Override
        public String getInvited() {
            return ((OrganizationMember)this.instance).getInvited();
        }

        @Override
        public ByteString getInvitedBytes() {
            return ((OrganizationMember)this.instance).getInvitedBytes();
        }

        public Builder setInvited(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setInvited(value);
            return this;
        }

        public Builder clearInvited() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearInvited();
            return this;
        }

        public Builder setInvitedBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setInvitedBytes(value);
            return this;
        }

        @Override
        public boolean getBanned() {
            return ((OrganizationMember)this.instance).getBanned();
        }

        public Builder setBanned(boolean value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setBanned(value);
            return this;
        }

        public Builder clearBanned() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearBanned();
            return this;
        }

        @Override
        public String getAvatar() {
            return ((OrganizationMember)this.instance).getAvatar();
        }

        @Override
        public ByteString getAvatarBytes() {
            return ((OrganizationMember)this.instance).getAvatarBytes();
        }

        public Builder setAvatar(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAvatar(value);
            return this;
        }

        public Builder clearAvatar() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearAvatar();
            return this;
        }

        public Builder setAvatarBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAvatarBytes(value);
            return this;
        }

        @Override
        public String getAvatarBackgroundColour() {
            return ((OrganizationMember)this.instance).getAvatarBackgroundColour();
        }

        @Override
        public ByteString getAvatarBackgroundColourBytes() {
            return ((OrganizationMember)this.instance).getAvatarBackgroundColourBytes();
        }

        public Builder setAvatarBackgroundColour(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAvatarBackgroundColour(value);
            return this;
        }

        public Builder clearAvatarBackgroundColour() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearAvatarBackgroundColour();
            return this;
        }

        public Builder setAvatarBackgroundColourBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setAvatarBackgroundColourBytes(value);
            return this;
        }

        @Override
        public String getTimezone() {
            return ((OrganizationMember)this.instance).getTimezone();
        }

        @Override
        public ByteString getTimezoneBytes() {
            return ((OrganizationMember)this.instance).getTimezoneBytes();
        }

        public Builder setTimezone(String value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setTimezone(value);
            return this;
        }

        public Builder clearTimezone() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearTimezone();
            return this;
        }

        public Builder setTimezoneBytes(ByteString value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setTimezoneBytes(value);
            return this;
        }

        @Override
        public int getNotificationPreferenceValue() {
            return ((OrganizationMember)this.instance).getNotificationPreferenceValue();
        }

        public Builder setNotificationPreferenceValue(int value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setNotificationPreferenceValue(value);
            return this;
        }

        @Override
        public UserNotificationPreference getNotificationPreference() {
            return ((OrganizationMember)this.instance).getNotificationPreference();
        }

        public Builder setNotificationPreference(UserNotificationPreference value) {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).setNotificationPreference(value);
            return this;
        }

        public Builder clearNotificationPreference() {
            this.copyOnWrite();
            ((OrganizationMember)this.instance).clearNotificationPreference();
            return this;
        }
    }
}

