/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.stats.prometheus.ScopeContext;

public class ThreadScopedDataSketchesStatsLogger
implements OpStatsLogger {
    private ThreadLocal<DataSketchesOpStatsLogger> statsLoggers;
    private DataSketchesOpStatsLogger defaultStatsLogger;
    private Map<String, String> originalLabels;
    private ScopeContext scopeContext;
    private PrometheusMetricsProvider provider;

    public ThreadScopedDataSketchesStatsLogger(PrometheusMetricsProvider provider, ScopeContext scopeContext, Map<String, String> labels) {
        this.provider = provider;
        this.scopeContext = scopeContext;
        this.originalLabels = labels;
        this.defaultStatsLogger = new DataSketchesOpStatsLogger(labels);
        HashMap<String, String> defaultLabels = new HashMap<String, String>(labels);
        defaultLabels.put("threadPool", "?");
        defaultLabels.put("thread", "?");
        this.defaultStatsLogger.initializeThread(defaultLabels);
        this.statsLoggers = ThreadLocal.withInitial(() -> new DataSketchesOpStatsLogger(labels));
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        this.getStatsLogger().registerFailedEvent(eventLatency, unit);
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        this.getStatsLogger().registerSuccessfulEvent(eventLatency, unit);
    }

    public void registerSuccessfulValue(long value) {
        this.getStatsLogger().registerSuccessfulValue(value);
    }

    public void registerFailedValue(long value) {
        this.getStatsLogger().registerFailedValue(value);
    }

    public OpStatsData toOpStatsData() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    private DataSketchesOpStatsLogger getStatsLogger() {
        DataSketchesOpStatsLogger statsLogger = this.statsLoggers.get();
        if (!statsLogger.isThreadInitialized()) {
            ThreadRegistry.ThreadPoolThread tpt = ThreadRegistry.get();
            if (tpt == null) {
                this.statsLoggers.set(this.defaultStatsLogger);
                this.provider.opStats.put(new ScopeContext(this.scopeContext.getScope(), this.originalLabels), this.defaultStatsLogger);
                return this.defaultStatsLogger;
            }
            HashMap<String, String> threadScopedlabels = new HashMap<String, String>(this.originalLabels);
            threadScopedlabels.put("threadPool", tpt.getThreadPool());
            threadScopedlabels.put("thread", String.valueOf(tpt.getOrdinal()));
            statsLogger.initializeThread(threadScopedlabels);
            this.provider.opStats.put(new ScopeContext(this.scopeContext.getScope(), threadScopedlabels), statsLogger);
        }
        return statsLogger;
    }
}

