/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class PulsarSourceOptions {
    public static final ConfigOption<String> ADMIN_URL = ConfigOptions.key((String)"admin.url").stringType().noDefaultValue().withDescription("The url to Pulsar admin.");
    public static final ConfigOption<Long> PARTITION_DISCOVERY_INTERVAL_MS = ConfigOptions.key((String)"partition.discovery.interval.ms").longType().defaultValue((Object)30000L).withDescription("The interval in milliseconds for the Pulsar source to discover the new partitions. A non-positive value disables the partition discovery.");
    public static final ConfigOption<Long> CLOSE_TIMEOUT_MS = ConfigOptions.key((String)"close.timeout.ms").longType().defaultValue((Object)10000L).withDescription("The max time to wait when closing components.");
    public static final ConfigOption<Long> MAX_FETCH_TIME = ConfigOptions.key((String)"max.fetch.time").longType().defaultValue((Object)500L).withDescription("The max time to wait when fetching records. A longer time increases throughput but also latency. A fetch batch might be finished earlier because of max.fetch.records.");
    public static final ConfigOption<Integer> MAX_FETCH_RECORDS = ConfigOptions.key((String)"max.fetch.records").intType().defaultValue((Object)100).withDescription("The max number of records to fetch to wait when polling. A longer time increases throughput but also latency.A fetch batch might be finished earlier because of max.fetch.time.");
    public static final ConfigOption<OffsetVerification> VERIFY_INITIAL_OFFSETS = ConfigOptions.key((String)"verify.initial.offsets").enumType(OffsetVerification.class).defaultValue((Object)OffsetVerification.FAIL_ON_MISMATCH).withDescription("Upon (re)starting the source checks whether the expected message can be read. If failure is enabled the application fails, else it logs a warning. A possible solution is to adjust the retention settings in pulsar or ignoring the check result.");

    public static enum OffsetVerification {
        FAIL_ON_MISMATCH,
        WARN_ON_MISMATCH,
        IGNORE;

    }
}

