/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.guava18.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.client.api.Range;

public class SerializableRange
implements Externalizable,
Comparable<SerializableRange> {
    public static int fullRangeStart = 0;
    public static int fullRangeEnd = 65535;
    private Range range;

    public Range getPulsarRange() {
        return this.range;
    }

    public SerializableRange(Range range) {
        this.range = range;
    }

    public SerializableRange(int start, int end) {
        this.range = Range.of(start, end);
    }

    public SerializableRange() {
        this(null);
    }

    public static SerializableRange of(Range range) {
        return new SerializableRange(range);
    }

    public static SerializableRange of(int start, int end) {
        return new SerializableRange(start, end);
    }

    public static SerializableRange ofFullRange() {
        return new SerializableRange(fullRangeStart, fullRangeEnd);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.range.getStart());
        out.writeInt(this.range.getEnd());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int start = in.readInt();
        int end = in.readInt();
        this.range = Range.of(start, end);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)this.range).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerializableRange)) {
            return false;
        }
        SerializableRange that = (SerializableRange)o;
        return Objects.equals(this.range.getStart(), that.range.getStart()) && Objects.equals(this.range.getEnd(), that.range.getEnd());
    }

    public int hashCode() {
        return Objects.hash(this.range.getStart(), this.range.getEnd());
    }

    @Override
    public int compareTo(@NotNull SerializableRange o) {
        return ComparisonChain.start().compare(this.range.getStart(), o.range.getStart()).compare(this.range.getEnd(), o.range.getEnd()).result();
    }
}

