/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.pulsar.config.StartupMode;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarCatalogSupport;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarDynamicTableSink;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarDynamicTableSource;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarSinkSemantic;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.streaming.connectors.pulsar.util.KeyHashMessageRouterImpl;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.pulsar.common.naming.TopicName;

public class PulsarDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "pulsar";
    public static final String UPSERT_CONNECTOR = "upsert-pulsar";
    private final boolean inCatalog;

    public PulsarDynamicTableFactory() {
        this.inCatalog = false;
    }

    public PulsarDynamicTableFactory(boolean inCatalog) {
        this.inCatalog = inCatalog;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        if (((String)tableOptions.get(PulsarTableOptions.CONNECTOR)).equals(UPSERT_CONNECTOR)) {
            return this.createDynamicTableSinkUpsert(context);
        }
        if (this.inCatalog) {
            ObjectIdentifier table = context.getObjectIdentifier();
            String topic = TopicName.get(table.getDatabaseName() + "/" + table.getObjectName()).toString();
            ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC, Collections.singletonList(topic));
        }
        List topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = PulsarDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = PulsarDynamicTableFactory.getValueEncodingFormat(helper);
        helper.validateExcept(new String[]{"properties.", "type", "table-default-partitions", "default-database"});
        PulsarTableOptions.validateTableSinkOptions(tableOptions);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), context.getCatalogTable(), valueEncodingFormat);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        return this.createPulsarTableSink(tableOptions, topics, adminUrl, serverUrl, keyEncodingFormat, valueEncodingFormat, properties, physicalDataType, keyProjection, valueProjection, keyPrefix, context);
    }

    private PulsarDynamicTableSink createPulsarTableSink(ReadableConfig tableOptions, List<String> topics, String adminUrl, String serverUrl, Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, Properties properties, DataType physicalDataType, int[] keyProjection, int[] valueProjection, String keyPrefix, DynamicTableFactory.Context context) {
        String formatType = tableOptions.getOptional(FactoryUtil.FORMAT).orElseGet(() -> (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT));
        Integer parallelism = tableOptions.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null);
        return new PulsarDynamicTableSink(serverUrl, adminUrl, topics.get(0), physicalDataType, properties, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, PulsarTableOptions.getSinkSemantic(tableOptions), formatType, false, parallelism, PulsarTableOptions.getMessageRouter(tableOptions, context.getClassLoader()).orElse(null));
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        if (((String)tableOptions.get(PulsarTableOptions.CONNECTOR)).equals(UPSERT_CONNECTOR)) {
            return this.createDynamicTableSourceUpsert(context);
        }
        List<String> topics = new ArrayList();
        String topicPattern = null;
        if (PulsarCatalogSupport.isNativeFlinkDatabase(context.getObjectIdentifier().getDatabaseName())) {
            topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
            if (topics != null && !topics.isEmpty()) {
                ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC, Collections.singletonList(topics.get(0)));
            }
            if ((topicPattern = (String)tableOptions.get(PulsarTableOptions.TOPIC_PATTERN)) != null) {
                ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC_PATTERN, (Object)topicPattern);
            }
        } else {
            ObjectIdentifier table = context.getObjectIdentifier();
            String topic = TopicName.get(table.getDatabaseName() + "/" + table.getObjectName()).toString();
            ((Configuration)tableOptions).set(PulsarTableOptions.TOPIC, Collections.singletonList(topic));
            topics.add(topic);
        }
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serviceUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = PulsarDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = PulsarDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties.", "type", "table-default-partitions", "default-database"});
        PulsarTableOptions.validateTableSourceOptions(tableOptions);
        PulsarTableOptions.validateSinkMessageRouter(tableOptions);
        PulsarDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), context.getCatalogTable(), valueDecodingFormat);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarTableOptions.StartupOptions startupOptions = PulsarTableOptions.getStartupOptions(tableOptions);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        return this.createPulsarTableSource(physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, serviceUrl, adminUrl, properties, startupOptions);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(PulsarTableOptions.SERVICE_URL);
        options.add(PulsarTableOptions.ADMIN_URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(PulsarTableOptions.KEY_FORMAT);
        options.add(PulsarTableOptions.KEY_FIELDS);
        options.add(PulsarTableOptions.KEY_FIELDS_PREFIX);
        options.add(PulsarTableOptions.VALUE_FORMAT);
        options.add(PulsarTableOptions.VALUE_FIELDS_INCLUDE);
        options.add(PulsarTableOptions.TOPIC);
        options.add(PulsarTableOptions.TOPIC_PATTERN);
        options.add(PulsarTableOptions.SCAN_STARTUP_MODE);
        options.add(PulsarTableOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(PulsarTableOptions.SCAN_STARTUP_SUB_NAME);
        options.add(PulsarTableOptions.SCAN_STARTUP_SUB_START_OFFSET);
        options.add(PulsarTableOptions.PARTITION_DISCOVERY_INTERVAL_MILLIS);
        options.add(PulsarTableOptions.SINK_SEMANTIC);
        options.add(PulsarTableOptions.SINK_MESSAGE_ROUTER);
        options.add(FactoryUtil.SINK_PARALLELISM);
        options.add(PulsarTableOptions.PROPERTIES);
        return options;
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(PulsarTableOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(PulsarTableOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT));
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, CatalogTable catalogTable, Format format) {
        if (catalogTable.getSchema().getPrimaryKey().isPresent() && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration options = Configuration.fromMap((Map)catalogTable.getOptions());
            String formatName = (String)options.getOptional(FactoryUtil.FORMAT).orElse(options.get(PulsarTableOptions.VALUE_FORMAT));
            throw new ValidationException(String.format("The Pulsar table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    protected PulsarDynamicTableSource createPulsarTableSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable String topicPattern, String serviceUrl, String adminUrl, Properties properties, PulsarTableOptions.StartupOptions startupOptions) {
        return new PulsarDynamicTableSource(physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, serviceUrl, adminUrl, properties, startupOptions, false);
    }

    public DynamicTableSource createDynamicTableSourceUpsert(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        DecodingFormat keyDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        DecodingFormat valueDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        List topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        String topicPattern = (String)tableOptions.get(PulsarTableOptions.TOPIC_PATTERN);
        helper.validateExcept(new String[]{"properties."});
        TableSchema schema = context.getCatalogTable().getSchema();
        PulsarDynamicTableFactory.validateTableOptionsUpsert(tableOptions, (Format)keyDecodingFormat, (Format)valueDecodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjectionsUpsert(context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarTableOptions.StartupOptions startupOptions = new PulsarTableOptions.StartupOptions();
        startupOptions.startupMode = StartupMode.EARLIEST;
        startupOptions.specificOffsets = Collections.EMPTY_MAP;
        return new PulsarDynamicTableSource(schema.toPhysicalRowDataType(), (DecodingFormat<DeserializationSchema<RowData>>)keyDecodingFormat, new DecodingFormatWrapper((DecodingFormat<DeserializationSchema<RowData>>)valueDecodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, topics, topicPattern, serverUrl, adminUrl, properties, startupOptions, true);
    }

    private static void validateTableOptionsUpsert(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, TableSchema schema) {
        PulsarDynamicTableFactory.validateTopicUpsert(tableOptions);
        PulsarDynamicTableFactory.validateFormatUpsert(keyFormat, valueFormat, tableOptions);
        PulsarDynamicTableFactory.validatePKConstraintsUpsert(schema);
    }

    private static void validateTopicUpsert(ReadableConfig tableOptions) {
        List topic = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        if (topic.size() > 1) {
            throw new ValidationException("The 'upsert-pulsar' connector doesn't support topic list now. Please use single topic as the value of the parameter 'topic'.");
        }
    }

    private static void validateFormatUpsert(Format keyFormat, Format valueFormat, ReadableConfig tableOptions) {
        if (!keyFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(PulsarTableOptions.KEY_FORMAT);
            throw new ValidationException(String.format("'upsert-pulsar' connector doesn't support '%s' as key format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
        if (!valueFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT);
            throw new ValidationException(String.format("'upsert-Pulsar' connector doesn't support '%s' as value format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
    }

    private static void validatePKConstraintsUpsert(TableSchema schema) {
        if (!schema.getPrimaryKey().isPresent()) {
            throw new ValidationException("'upsert-pulsar' tables require to define a PRIMARY KEY constraint. The PRIMARY KEY specifies which columns should be read from or write to the Pulsar message key. The PRIMARY KEY also defines records in the 'upsert-pulsar' table should update or delete on which keys.");
        }
    }

    private Tuple2<int[], int[]> createKeyValueProjectionsUpsert(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        List keyFields = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        DataType physicalDataType = schema.toPhysicalRowDataType();
        Configuration tableOptions = Configuration.fromMap((Map)catalogTable.getOptions());
        tableOptions.set(PulsarTableOptions.KEY_FIELDS, (Object)keyFields);
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    private DynamicTableSink createDynamicTableSinkUpsert(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        TableSchema schema = context.getCatalogTable().getSchema();
        PulsarDynamicTableFactory.validateTableOptionsUpsert(tableOptions, (Format)keyEncodingFormat, (Format)valueEncodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjectionsUpsert(context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        Integer parallelism = (Integer)tableOptions.get(FactoryUtil.SINK_PARALLELISM);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        String formatType = tableOptions.getOptional(FactoryUtil.FORMAT).orElseGet(() -> (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT));
        return new PulsarDynamicTableSink(serverUrl, adminUrl, (String)((List)tableOptions.get(PulsarTableOptions.TOPIC)).get(0), schema.toPhysicalRowDataType(), properties, (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, new EncodingFormatWrapper((EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, PulsarSinkSemantic.AT_LEAST_ONCE, formatType, true, parallelism, KeyHashMessageRouterImpl.INSTANCE);
    }

    protected static class EncodingFormatWrapper
    implements EncodingFormat<SerializationSchema<RowData>> {
        private final EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat;
        public static final ChangelogMode SINK_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public EncodingFormatWrapper(EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat) {
            this.innerEncodingFormat = innerEncodingFormat;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
            return (SerializationSchema)this.innerEncodingFormat.createRuntimeEncoder(context, consumedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SINK_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncodingFormatWrapper that = (EncodingFormatWrapper)obj;
            return Objects.equals(this.innerEncodingFormat, that.innerEncodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerEncodingFormat);
        }
    }

    protected static class DecodingFormatWrapper
    implements DecodingFormat<DeserializationSchema<RowData>> {
        private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;
        private static final ChangelogMode SOURCE_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public DecodingFormatWrapper(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat) {
            this.innerDecodingFormat = innerDecodingFormat;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, producedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SOURCE_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecodingFormatWrapper that = (DecodingFormatWrapper)obj;
            return Objects.equals(this.innerDecodingFormat, that.innerDecodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerDecodingFormat);
        }
    }
}

