/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;

public class RowDataUtil {
    public static void setField(GenericRowData rowData, int pos, Object value) {
        if (value instanceof LocalDate) {
            rowData.setField(pos, (Object)((int)((LocalDate)value).toEpochDay()));
        } else if (value instanceof LocalTime) {
            rowData.setField(pos, (Object)((LocalTime)value).toNanoOfDay());
        } else if (value instanceof Instant) {
            rowData.setField(pos, (Object)TimestampData.fromInstant((Instant)((Instant)value)));
        } else if (value instanceof String) {
            rowData.setField(pos, (Object)StringData.fromString((String)((String)value)));
        } else if (value instanceof LocalDateTime) {
            rowData.setField(pos, (Object)TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)value)));
        } else if (value instanceof Map) {
            rowData.setField(pos, (Object)new GenericMapData((Map)value));
        } else {
            rowData.setField(pos, value);
        }
    }

    public static Object getField(RowData rowData, int pos, Class<?> clazz) {
        if (clazz.isAssignableFrom(LocalDate.class)) {
            int value = rowData.getInt(pos);
            return LocalDate.ofEpochDay(value);
        }
        if (clazz.isAssignableFrom(LocalTime.class)) {
            long value = rowData.getLong(pos);
            return LocalTime.ofNanoOfDay(value);
        }
        if (clazz.isAssignableFrom(Instant.class)) {
            TimestampData timestamp = rowData.getTimestamp(pos, 3);
            return timestamp.toInstant();
        }
        if (clazz.isAssignableFrom(String.class)) {
            return rowData.getString(pos).toString();
        }
        if (clazz.isAssignableFrom(LocalDateTime.class)) {
            return rowData.getTimestamp(pos, 3).toLocalDateTime();
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz == Integer.TYPE) {
            return rowData.getInt(pos);
        }
        if (clazz.isAssignableFrom(Long.class) || clazz == Long.TYPE) {
            return rowData.getLong(pos);
        }
        if (clazz.isAssignableFrom(Byte.class) || clazz == Byte.TYPE) {
            return rowData.getByte(pos);
        }
        if (clazz.isAssignableFrom(Short.class) || clazz == Short.TYPE) {
            return rowData.getShort(pos);
        }
        if (clazz.isAssignableFrom(Float.class) || clazz == Float.TYPE) {
            return Float.valueOf(rowData.getFloat(pos));
        }
        if (clazz.isAssignableFrom(Double.class) || clazz == Double.TYPE) {
            return rowData.getDouble(pos);
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return rowData.getBinary(pos);
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz == Boolean.TYPE) {
            return rowData.getBoolean(pos);
        }
        if (clazz.isAssignableFrom(Instant.class)) {
            return rowData.getTimestamp(pos, 3).toInstant();
        }
        throw new IllegalArgumentException("not support " + clazz.getName());
    }
}

