/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.types.DataType;

public class FlinkTableSchemaWrapper
implements Serializable {
    private static final long serialVersionUID = 6529685098267757690L;
    List<Tuple3<String, String, DataType>> watermarkSpecs;
    Tuple3<Boolean, String, List<String>> primaryKey;
    List<Tuple4<Integer, String, DataType, String>> tableColumns;

    public static TableColumn toTableColumn(Tuple4<Integer, String, DataType, String> tuple) {
        switch ((Integer)tuple.f0) {
            case 0: {
                return TableColumn.physical((String)((String)tuple.f1), (DataType)((DataType)tuple.f2));
            }
            case 1: {
                return TableColumn.computed((String)((String)tuple.f1), (DataType)((DataType)tuple.f2), (String)((String)tuple.f3));
            }
            case 2: {
                return TableColumn.metadata((String)((String)tuple.f1), (DataType)((DataType)tuple.f2));
            }
        }
        throw new CatalogException("Failed to restore table column");
    }

    public static Tuple4<Integer, String, DataType, String> fromTableColumn(TableColumn tableColumn) {
        if (tableColumn instanceof TableColumn.PhysicalColumn) {
            return new Tuple4((Object)0, (Object)tableColumn.getName(), (Object)tableColumn.getType(), (Object)"");
        }
        if (tableColumn instanceof TableColumn.ComputedColumn) {
            return new Tuple4((Object)1, (Object)tableColumn.getName(), (Object)tableColumn.getType(), (Object)((TableColumn.ComputedColumn)tableColumn).getExpression());
        }
        if (tableColumn instanceof TableColumn.MetadataColumn) {
            return new Tuple4((Object)2, (Object)tableColumn.getName(), (Object)tableColumn.getType(), (Object)"");
        }
        throw new CatalogException("Can't recognize table column type.");
    }

    public List<Tuple3<String, String, DataType>> getWatermarkSpecs() {
        return this.watermarkSpecs;
    }

    public Tuple3<Boolean, String, List<String>> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<Tuple4<Integer, String, DataType, String>> getTableColumns() {
        return this.tableColumns;
    }

    public void setWatermarkSpecs(List<Tuple3<String, String, DataType>> watermarkSpecs) {
        this.watermarkSpecs = watermarkSpecs;
    }

    public void setPrimaryKey(Tuple3<Boolean, String, List<String>> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setTableColumns(List<Tuple4<Integer, String, DataType, String>> tableColumns) {
        this.tableColumns = tableColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkTableSchemaWrapper)) {
            return false;
        }
        FlinkTableSchemaWrapper other = (FlinkTableSchemaWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Tuple3<String, String, DataType>> this$watermarkSpecs = this.getWatermarkSpecs();
        List<Tuple3<String, String, DataType>> other$watermarkSpecs = other.getWatermarkSpecs();
        if (this$watermarkSpecs == null ? other$watermarkSpecs != null : !((Object)this$watermarkSpecs).equals(other$watermarkSpecs)) {
            return false;
        }
        Tuple3<Boolean, String, List<String>> this$primaryKey = this.getPrimaryKey();
        Tuple3<Boolean, String, List<String>> other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<Tuple4<Integer, String, DataType, String>> this$tableColumns = this.getTableColumns();
        List<Tuple4<Integer, String, DataType, String>> other$tableColumns = other.getTableColumns();
        return !(this$tableColumns == null ? other$tableColumns != null : !((Object)this$tableColumns).equals(other$tableColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkTableSchemaWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tuple3<String, String, DataType>> $watermarkSpecs = this.getWatermarkSpecs();
        result = result * 59 + ($watermarkSpecs == null ? 43 : ((Object)$watermarkSpecs).hashCode());
        Tuple3<Boolean, String, List<String>> $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<Tuple4<Integer, String, DataType, String>> $tableColumns = this.getTableColumns();
        result = result * 59 + ($tableColumns == null ? 43 : ((Object)$tableColumns).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkTableSchemaWrapper(watermarkSpecs=" + this.getWatermarkSpecs() + ", primaryKey=" + this.getPrimaryKey() + ", tableColumns=" + this.getTableColumns() + ")";
    }
}

