/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.pulsar.FlinkTableSchemaWrapper;
import org.apache.flink.table.runtime.util.JsonUtils;
import org.apache.flink.table.types.DataType;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public final class TableSchemaHelper {
    public static SchemaInfo serialize(CatalogBaseTable table) throws IOException {
        byte[] schemaBytes;
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("COMMENT", table.getComment());
        propertyMap.put("OPTIONS", JsonUtils.MAPPER.writeValueAsString((Object)table.getOptions()));
        FlinkTableSchemaWrapper tableSchema = new FlinkTableSchemaWrapper();
        tableSchema.setWatermarkSpecs(table.getSchema().getWatermarkSpecs().stream().map(spec -> new Tuple3((Object)spec.getRowtimeAttribute(), (Object)spec.getWatermarkExpr(), (Object)spec.getWatermarkExprOutputType())).collect(Collectors.toList()));
        Optional pkey = table.getSchema().getPrimaryKey();
        if (pkey.isPresent()) {
            tableSchema.setPrimaryKey((Tuple3<Boolean, String, List<String>>)new Tuple3((Object)true, (Object)((UniqueConstraint)pkey.get()).getName(), (Object)((UniqueConstraint)pkey.get()).getColumns()));
        } else {
            tableSchema.setPrimaryKey((Tuple3<Boolean, String, List<String>>)new Tuple3((Object)false, (Object)"", null));
        }
        List<Tuple4<Integer, String, DataType, String>> columns = table.getSchema().getTableColumns().stream().map(tc -> FlinkTableSchemaWrapper.fromTableColumn(tc)).collect(Collectors.toList());
        tableSchema.setTableColumns(columns);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(tableSchema);
            out.flush();
            schemaBytes = Base64.getEncoder().encode(bos.toByteArray());
        }
        SchemaInfoImpl tableInfo = SchemaInfoImpl.builder().name("tableMetadata").type(SchemaType.BYTES).schema(schemaBytes).properties(propertyMap).build();
        return tableInfo;
    }

    public static CatalogTable deserialize(SchemaInfo metadata, Map<String, String> defaultOptions) throws IOException, ClassNotFoundException {
        FlinkTableSchemaWrapper schemaWrapper;
        Map<String, String> properties = metadata.getProperties();
        String comment = properties.get("COMMENT");
        HashMap tableOptions = (HashMap)JsonUtils.MAPPER.readValue(properties.get("OPTIONS"), (TypeReference)new TypeReference<HashMap<String, String>>(){});
        defaultOptions.putAll(tableOptions);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(metadata.getSchema()));
             ObjectInputStream ois = new ObjectInputStream(bis);){
            schemaWrapper = (FlinkTableSchemaWrapper)ois.readObject();
        }
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        schemaWrapper.watermarkSpecs.forEach(t -> tableSchemaBuilder.watermark(new WatermarkSpec((String)t.f0, (String)t.f1, (DataType)t.f2)));
        if (((Boolean)schemaWrapper.primaryKey.f0).booleanValue()) {
            tableSchemaBuilder.primaryKey((String)schemaWrapper.primaryKey.f1, ((List)schemaWrapper.primaryKey.f2).toArray(new String[0]));
        }
        schemaWrapper.tableColumns.forEach(t -> tableSchemaBuilder.add(FlinkTableSchemaWrapper.toTableColumn((Tuple4<Integer, String, DataType, String>)t)));
        return new CatalogTableImpl(tableSchemaBuilder.build(), defaultOptions, comment);
    }
}

