/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.pulsar.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.pulsar.PulsarCatalog;
import org.apache.flink.table.catalog.pulsar.PulsarCatalogValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.CatalogFactory;

public class PulsarCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String name, Map<String, String> properties) {
        DescriptorProperties dp = this.getValidateProperties(properties);
        String defaultDB = dp.getOptionalString("default-database").orElse("public/default");
        String adminUrl = dp.getString(PulsarCatalogValidator.CATALOG_ADMIN_URL);
        return new PulsarCatalog(adminUrl, name, dp.asMap(), defaultDB);
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "pulsar");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> props = new ArrayList<String>();
        props.add("default-database");
        props.add("pulsar-version");
        props.add(PulsarCatalogValidator.CATALOG_SERVICE_URL);
        props.add(PulsarCatalogValidator.CATALOG_ADMIN_URL);
        props.add(PulsarCatalogValidator.CATALOG_STARTUP_MODE);
        props.add("table-default-partitions");
        props.add(PulsarTableOptions.KEY_FORMAT.key());
        props.add(PulsarTableOptions.KEY_FIELDS.key());
        props.add(PulsarTableOptions.KEY_FIELDS_PREFIX.key());
        props.add(PulsarTableOptions.VALUE_FORMAT.key());
        props.add(PulsarTableOptions.VALUE_FIELDS_INCLUDE.key());
        props.add(PulsarTableOptions.SINK_SEMANTIC.key());
        props.add("format");
        props.add("format.*");
        props.add("properties.*");
        return props;
    }

    private DescriptorProperties getValidateProperties(Map<String, String> properties) {
        DescriptorProperties dp = new DescriptorProperties();
        dp.putProperties(properties);
        new PulsarCatalogValidator().validate(dp);
        return dp;
    }
}

