/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.pulsar.source.SplitSchedulingStrategy;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

public class HashSplitSchedulingStrategy
implements SplitSchedulingStrategy {
    public static final HashSplitSchedulingStrategy INSTANCE = new HashSplitSchedulingStrategy();

    private HashSplitSchedulingStrategy() {
    }

    @Override
    public int getIndexOfReader(int numReaders, PulsarPartitionSplit split) {
        return (split.getTopic().hashCode() * 31 & Integer.MAX_VALUE) % numReaders;
    }

    @Override
    public void addSplitsBack(Map<Integer, List<PulsarPartitionSplit>> pendingPartitionSplitAssignment, List<PulsarPartitionSplit> splits, int subtaskId, int numReaders) {
        for (PulsarPartitionSplit split : splits) {
            pendingPartitionSplitAssignment.computeIfAbsent(this.getIndexOfReader(numReaders, split), r -> new ArrayList()).add(split);
        }
    }
}

