/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.protobuf.PbDecodingFormat;
import org.apache.flink.formats.protobuf.PbEncodingFormat;
import org.apache.flink.formats.protobuf.PbFormatOptions;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

public class PbFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "protobuf";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        String messageClassName = (String)formatOptions.get(PbFormatOptions.MESSAGE_CLASS_NAME);
        boolean ignoreParseErrors = (Boolean)formatOptions.get(PbFormatOptions.IGNORE_PARSE_ERRORS);
        boolean readDefaultValues = (Boolean)formatOptions.get(PbFormatOptions.READ_DEFAULT_VALUES);
        return new PbDecodingFormat(messageClassName, ignoreParseErrors, readDefaultValues);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        String messageClassName = (String)formatOptions.get(PbFormatOptions.MESSAGE_CLASS_NAME);
        return new PbEncodingFormat(messageClassName);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet result = new HashSet();
        result.add(PbFormatOptions.MESSAGE_CLASS_NAME);
        return result;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet result = new HashSet();
        result.add(PbFormatOptions.IGNORE_PARSE_ERRORS);
        result.add(PbFormatOptions.READ_DEFAULT_VALUES);
        return result;
    }
}

