/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenUtils;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenArrayDeserializer
implements PbCodegenDeserializer {
    private Descriptors.FieldDescriptor fd;
    private LogicalType elementType;
    private boolean readDefaultValues;
    private PbCodegenAppender appender = new PbCodegenAppender();

    public PbCodegenArrayDeserializer(Descriptors.FieldDescriptor fd, LogicalType elementType, boolean readDefaultValues) {
        this.fd = fd;
        this.elementType = elementType;
        this.readDefaultValues = readDefaultValues;
    }

    @Override
    public String codegen(String returnVarName, String messageGetStr) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        String protoTypeStr = PbCodegenUtils.getTypeStrFromProto(this.fd, false);
        String listPbVar = "list" + uid;
        String newArrDataVar = "newArr" + uid;
        String subReturnDataVar = "subReturnVar" + uid;
        String iVar = "i" + uid;
        String subPbObjVar = "subObj" + uid;
        this.appender.appendLine("List<" + protoTypeStr + "> " + listPbVar + "=" + messageGetStr);
        this.appender.appendLine("Object[] " + newArrDataVar + "= new Object[" + listPbVar + ".size()]");
        this.appender.appendSegment("for(int " + iVar + "=0;" + iVar + " < " + listPbVar + ".size(); " + iVar + "++){");
        this.appender.appendLine("Object " + subReturnDataVar + " = null");
        this.appender.appendLine(protoTypeStr + " " + subPbObjVar + " = (" + protoTypeStr + ")" + listPbVar + ".get(" + iVar + ")");
        PbCodegenDeserializer codegenDes = PbCodegenDeserializeFactory.getPbCodegenDes(this.fd, this.elementType, this.readDefaultValues);
        String code = codegenDes.codegen(subReturnDataVar, subPbObjVar);
        this.appender.appendSegment(code);
        this.appender.appendLine(newArrDataVar + "[" + iVar + "]=" + subReturnDataVar + "");
        this.appender.appendSegment("}");
        this.appender.appendLine(returnVarName + " = new GenericArrayData(" + newArrDataVar + ")");
        return this.appender.code();
    }
}

