/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenUtils;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.table.types.logical.LogicalType;

public class PbCodegenArraySerializer
implements PbCodegenSerializer {
    private Descriptors.FieldDescriptor fd;
    private LogicalType elementType;

    public PbCodegenArraySerializer(Descriptors.FieldDescriptor fd, LogicalType elementType) {
        this.fd = fd;
        this.elementType = elementType;
    }

    @Override
    public String codegen(String returnVarName, String rowFieldGetter) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        PbCodegenAppender appender = new PbCodegenAppender();
        String protoTypeStr = PbCodegenUtils.getTypeStrFromProto(this.fd, false);
        String pbListVar = "pbList" + uid;
        String arrayDataVar = "arrData" + uid;
        String elementDataVar = "eleData" + uid;
        String elementPbVar = "elementPbVar" + uid;
        String iVar = "i" + uid;
        appender.appendLine("ArrayData " + arrayDataVar + " = " + rowFieldGetter);
        appender.appendLine("List<" + protoTypeStr + "> " + pbListVar + "= new ArrayList()");
        appender.appendSegment("for(int " + iVar + "=0;" + iVar + " < " + arrayDataVar + ".size(); " + iVar + "++){");
        String elementGenCode = PbCodegenUtils.generateArrElementCodeWithDefaultValue(arrayDataVar, iVar, elementPbVar, elementDataVar, this.fd, this.elementType);
        appender.appendSegment(elementGenCode);
        appender.appendLine(pbListVar + ".add( " + elementPbVar + ")");
        appender.appendSegment("}");
        appender.appendLine(returnVarName + " = " + pbListVar);
        return appender.code();
    }
}

