/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenUtils;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbCodegenMapSerializer
implements PbCodegenSerializer {
    private Descriptors.FieldDescriptor fd;
    private MapType mapType;

    public PbCodegenMapSerializer(Descriptors.FieldDescriptor fd, MapType mapType) {
        this.fd = fd;
        this.mapType = mapType;
    }

    @Override
    public String codegen(String returnVarName, String rowFieldGetStr) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        LogicalType keyType = this.mapType.getKeyType();
        LogicalType valueType = this.mapType.getValueType();
        Descriptors.FieldDescriptor keyFd = this.fd.getMessageType().findFieldByName("key");
        Descriptors.FieldDescriptor valueFd = this.fd.getMessageType().findFieldByName("value");
        PbCodegenAppender appender = new PbCodegenAppender();
        String keyProtoTypeStr = PbCodegenUtils.getTypeStrFromProto(keyFd, false);
        String valueProtoTypeStr = PbCodegenUtils.getTypeStrFromProto(valueFd, false);
        String keyArrDataVar = "keyArrData" + uid;
        String valueArrDataVar = "valueArrData" + uid;
        String iVar = "i" + uid;
        String pbMapVar = "resultPbMap" + uid;
        String keyPbVar = "keyPbVar" + uid;
        String valuePbVar = "valuePbVar" + uid;
        String keyDataVar = "keyDataVar" + uid;
        String valueDataVar = "valueDataVar" + uid;
        appender.appendLine("ArrayData " + keyArrDataVar + " = " + rowFieldGetStr + ".keyArray()");
        appender.appendLine("ArrayData " + valueArrDataVar + " = " + rowFieldGetStr + ".valueArray()");
        appender.appendLine("Map<" + keyProtoTypeStr + ", " + valueProtoTypeStr + "> " + pbMapVar + " = new HashMap()");
        appender.appendSegment("for(int " + iVar + " = 0; " + iVar + " < " + keyArrDataVar + ".size(); " + iVar + "++){");
        String keyGenCode = PbCodegenUtils.generateArrElementCodeWithDefaultValue(keyArrDataVar, iVar, keyPbVar, keyDataVar, keyFd, keyType);
        appender.appendSegment(keyGenCode);
        String valueGenCode = PbCodegenUtils.generateArrElementCodeWithDefaultValue(valueArrDataVar, iVar, valuePbVar, valueDataVar, valueFd, valueType);
        appender.appendSegment(valueGenCode);
        appender.appendLine(pbMapVar + ".put(" + keyPbVar + ", " + valuePbVar + ")");
        appender.appendSegment("}");
        appender.appendLine(returnVarName + " = " + pbMapVar);
        return appender.code();
    }
}

