/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.concurrent.ConcurrentMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava18.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava18.com.google.common.cache.RemovalListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedPulsarClient {
    private static final Logger log = LoggerFactory.getLogger(CachedPulsarClient.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static int cacheSize = 100;
    private static final RemovalListener<String, PulsarClientImpl> removalListener = notification -> {
        String config = (String)notification.getKey();
        PulsarClientImpl client = (PulsarClientImpl)notification.getValue();
        log.debug("Evicting pulsar client {} with config {}, due to {}", new Object[]{client, config, notification.getCause()});
        CachedPulsarClient.close(config, client);
    };
    private static final Cache<String, PulsarClientImpl> clientCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).removalListener(removalListener).build();

    public static void setCacheSize(int newSize) {
        cacheSize = newSize;
    }

    public static int getCacheSize() {
        return cacheSize;
    }

    private static PulsarClientImpl createPulsarClient(ClientConfigurationData clientConfig) throws PulsarClientException {
        PulsarClientImpl client;
        try {
            client = new PulsarClientImpl(clientConfig);
            log.debug("Created a new instance of PulsarClientImpl for clientConf = {}", (Object)clientConfig);
        }
        catch (PulsarClientException e) {
            log.error("Failed to create PulsarClientImpl for clientConf = {}", (Object)clientConfig);
            throw e;
        }
        return client;
    }

    public static synchronized PulsarClientImpl getOrCreate(ClientConfigurationData config) throws PulsarClientException {
        String key = CachedPulsarClient.serializeKey(config);
        PulsarClientImpl client = (PulsarClientImpl)clientCache.getIfPresent((Object)key);
        if (client == null) {
            client = CachedPulsarClient.createPulsarClient(config);
            clientCache.put((Object)key, (Object)client);
        }
        return client;
    }

    private static void close(String clientConfig, PulsarClientImpl client) {
        if (client != null) {
            try {
                log.info("Closing the Pulsar client with config {}", (Object)clientConfig);
                client.close();
            }
            catch (PulsarClientException e) {
                log.warn(String.format("Error while closing the Pulsar client %s", clientConfig), (Throwable)e);
            }
        }
    }

    private static String serializeKey(ClientConfigurationData clientConfig) {
        return mapper.writeValueAsString(clientConfig);
    }

    @VisibleForTesting
    static void close(ClientConfigurationData clientConfig) {
        String key = CachedPulsarClient.serializeKey(clientConfig);
        clientCache.invalidate((Object)key);
    }

    @VisibleForTesting
    static void clear() {
        log.info("Cleaning up guava cache.");
        clientCache.invalidateAll();
    }

    @VisibleForTesting
    static ConcurrentMap<String, PulsarClientImpl> getAsMap() {
        return clientCache.asMap();
    }

    private CachedPulsarClient() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

