/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.Properties;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class PulsarClientUtils {
    public static PulsarAdmin newAdminFromConf(String adminUrl, ClientConfigurationData clientConfigurationData) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(adminUrl).authentication(PulsarClientUtils.getAuth(clientConfigurationData)).build();
    }

    public static PulsarAdmin newAdminFromConf(String adminUrl, Properties properties) throws PulsarClientException {
        return PulsarClientUtils.newAdminFromConf(adminUrl, PulsarClientUtils.newClientConf(adminUrl, properties));
    }

    private static Authentication getAuth(ClientConfigurationData conf) throws PulsarClientException {
        if (!StringUtils.isBlank(conf.getAuthPluginClassName()) && !StringUtils.isBlank(conf.getAuthParams())) {
            return AuthenticationFactory.create(conf.getAuthPluginClassName(), conf.getAuthParams());
        }
        return AuthenticationDisabled.INSTANCE;
    }

    public static ClientConfigurationData newClientConf(String serviceUrl, Properties properties) {
        ClientConfigurationData clientConf = new ClientConfigurationData();
        clientConf.setServiceUrl(serviceUrl);
        if (properties != null) {
            clientConf.setAuthParams(properties.getProperty("auth-params"));
            clientConf.setAuthPluginClassName(properties.getProperty("auth-plugin-classname"));
        }
        return clientConf;
    }
}

